#!/bin/bash

# Build script for DQV/KTAC Agent macOS App Bundle
# Run this script to create a properly configured app bundle

echo "Building DQV/KTAC Agent macOS App Bundle..."

# Ensure the app bundle exists
if [ ! -d "Agent.app" ]; then
    echo "Error: Agent.app directory not found!"
    echo "Please run this script from the agent directory."
    exit 1
fi

# Make the main executable script executable
chmod +x Agent.app/Contents/MacOS/Agent

# Make the shell scripts executable
chmod +x start-agent.sh stop-agent.sh

# Verify the app bundle structure
echo "Verifying app bundle structure..."
if [ -f "Agent.app/Contents/Info.plist" ] && [ -f "Agent.app/Contents/MacOS/Agent" ]; then
    echo "✅ App bundle structure is correct"
else
    echo "❌ App bundle structure is incomplete"
    exit 1
fi

# Test the executable
echo "Testing executable permissions..."
if [ -x "Agent.app/Contents/MacOS/Agent" ]; then
    echo "✅ Main executable has correct permissions"
else
    echo "❌ Main executable permissions are incorrect"
    exit 1
fi

echo ""
echo "🎉 App bundle build complete!"
echo ""
echo "To use:"
echo "1. Double-click Agent.app to run the agent"
echo "2. No additional setup required!"
echo ""
echo "Files included:"
echo "- Agent.app (macOS app bundle)"
echo "- start-agent.sh (main agent script)"
echo "- stop-agent.sh (stop agent script)"
echo "- bootstrap-agent.jar (agent JAR file)"
echo ""
echo "The app bundle will automatically:"
echo "- Set correct permissions"
echo "- Start the agent"
echo "- Handle Java detection"
echo "- Show error dialogs if needed"
