/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tools.bootstrap.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.tinylog.Logger;

public class FileUtil {
    public static String preparePatchClassPath(File patchRootDir) {
        String ret = null;
        StringBuilder patchClassPath = new StringBuilder();
        if (patchRootDir.exists()) {
            File[] files = patchRootDir.listFiles();
            ArrayList<Double> patchNumbers = new ArrayList<Double>();
            HashMap<Double, String> subFolderMap = new HashMap<Double, String>();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    if (!f.isDirectory() || !f.getName().matches("[0-9]+\\.?[0-9]*")) continue;
                    Double patchNumber = new Double(f.getName());
                    patchNumbers.add(patchNumber);
                    subFolderMap.put(patchNumber, f.getName());
                }
                Collections.sort(patchNumbers, Collections.reverseOrder());
                boolean first = true;
                for (Double patchNum : patchNumbers) {
                    String name = (String)subFolderMap.get(patchNum);
                    if (first) {
                        first = false;
                    } else {
                        patchClassPath.append(",");
                    }
                    patchClassPath.append(patchRootDir.toString()).append(File.separator).append(name);
                }
                if (patchClassPath.length() > 0) {
                    ret = patchClassPath.toString();
                } else {
                    patchClassPath.append("No Patches available.");
                }
            }
        }
        Logger.info("Bootstraper: Using patch folders: {}", patchClassPath.toString());
        return ret;
    }
}

