/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tools.bootstrap.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.tinylog.Logger;

public class FileUnzipUtil {
    private static final int BUFFER_SIZE = 4096;

    public static void unzip(byte[] zipFile, String destDirectory) throws Exception {
        FileUnzipUtil.unzip(new ByteArrayInputStream(zipFile), destDirectory);
    }

    public static void unzip(InputStream inputStream, String destDirectory) throws Exception {
        ArrayList<String> alreadyCleanedFolders = new ArrayList<String>();
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        alreadyCleanedFolders.add(destDir.getAbsolutePath());
        ZipInputStream zipIn = new ZipInputStream(inputStream);
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            String rootFolderName = null;
            int index = entry.getName().indexOf("/");
            if (index > -1) {
                rootFolderName = entry.getName().substring(0, index);
            }
            if (!entry.isDirectory()) {
                File f = new File(filePath);
                if (!f.getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                FileUnzipUtil.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                if (!dir.getParentFile().exists()) {
                    dir.getParentFile().mkdirs();
                }
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) {
        try {
            File f = new File(filePath);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
            bos.close();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }
}

