/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tools.bootstrap.url;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class CustomClassLoader
extends ClassLoader {
    private ChildURLClassLoader childClassLoader;

    public CustomClassLoader(String jarDir) {
        super(Thread.currentThread().getContextClassLoader());
        URL[] urls;
        FileFilter jarFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") && !pathname.getName().toLowerCase().contains("bootstrap.jar");
            }
        };
        File[] jarFiles = new File(jarDir).listFiles(jarFilter);
        if (null != jarFiles) {
            urls = new URL[jarFiles.length];
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    urls[i] = jarFiles[i].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Could not get URL for JAR file: " + jarFiles[i], e);
                }
            }
        } else {
            urls = new URL[]{};
        }
        this.childClassLoader = new ChildURLClassLoader(urls, this.getParent());
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    private class ChildURLClassLoader
    extends URLClassLoader {
        private ClassLoader realParent;

        public ChildURLClassLoader(URL[] urls, ClassLoader realParent) {
            super(urls, (ClassLoader)null);
            this.realParent = realParent;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.realParent.loadClass(name);
            }
        }
    }
}

