/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tools.bootstrap;

import com.kumaran.tools.bootstrap.util.FileUnzipUtil;
import com.kumaran.tools.bootstrap.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinylog.Logger;

public class BootstrapServer {
    private static final String BOOTSTRAP_SERVER_EXECUTE_COMMAND = "bootstrap.server.$executeCommand$";
    private static final String BOOTSTRAP_SERVER_DEBUG_OPTION = "bootstrap.server.debugOption";
    public static final int EXITCODE_NORMAL = 0;
    public static final int EXITCODE_RESTART = 100;
    public static final int EXITCODE_UPDATE = 200;
    private Process serverProcess = null;
    private boolean isAlive = false;
    private String[] args = null;
    private Properties props = null;
    private static String providedConfigFile = null;
    private static String tacServerId = null;

    public static void main(String[] args) {
        for (String arg : args) {
            String value;
            if (!arg.startsWith("--spring.config.location") && !arg.startsWith("--config") || "agent.properties".equals(value = arg.substring(arg.indexOf("=") + 1))) continue;
            providedConfigFile = value;
        }
        BootstrapServer bootstrap = new BootstrapServer();
        bootstrap.start(args);
    }

    public void start(String[] args) {
        this.args = args;
        Thread shutdownHookThread = new Thread(){

            @Override
            public void run() {
                BootstrapServer.this.shutdownHook();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        this.loadProperties();
        this.updateApp();
        this.startSpringBootApp();
    }

    private void shutdownHook() {
        if (this.serverProcess != null && this.serverProcess.isAlive()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.serverProcess.isAlive()) {
                if (this.tryGracefulAgentShutdown()) {
                    while (this.serverProcess.isAlive()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    this.serverProcess.destroy();
                }
            }
        }
    }

    private boolean tryGracefulAgentShutdown() {
        boolean ret = false;
        try {
            String adminURL = this.props.getProperty("localAdminURL");
            String tacServerId = this.props.getProperty("tacServerId");
            if (adminURL != null && tacServerId != null) {
                URL url = new URL(adminURL + (adminURL.endsWith("/") ? "" : "/") + "admin/shutdown/" + tacServerId);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                int responseCode = con.getResponseCode();
                Logger.info("Bootstrapper: Shutdown Response Code: {}", responseCode);
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuffer response = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    String status = response.toString();
                    Logger.info("Bootstrapper: Shutdown Response message: {}", status);
                    if ("success".equalsIgnoreCase(status)) {
                        ret = true;
                    }
                } else {
                    Logger.info("Bootstrapper: Shutdown request not worked");
                }
            }
        }
        catch (ConnectException ce) {
            Logger.error((Throwable)ce, "Bootstrapper: Can't connect to admin server for initiating graceful shutting down. It may be already down.");
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
        return ret;
    }

    private void loadProperties() {
        Properties p = new Properties();
        boolean loaded = this.loadGivenFile("tac-server.properties", p);
        if (providedConfigFile != null) {
            loaded = this.loadGivenFile(providedConfigFile, p);
        }
        this.props = p;
        tacServerId = this.props.getProperty("tacServerId");
        System.out.println("Using Server Id as " + tacServerId);
        String currentFolder = System.getProperty("user.dir");
        if (!this.props.containsKey(BOOTSTRAP_SERVER_EXECUTE_COMMAND)) {
            this.props.put(BOOTSTRAP_SERVER_EXECUTE_COMMAND, "java -XX:+UseG1GC ${DEBUG-OPTION} ${CLASSPATH} -cp " + currentFolder + " -jar tac-server.jar");
        }
        if (!this.props.containsKey(BOOTSTRAP_SERVER_DEBUG_OPTION)) {
            this.props.put(BOOTSTRAP_SERVER_DEBUG_OPTION, "-agentlib:jdwp=transport=dt_socket,address=0.0.0.0:8000,server=y,suspend=n");
        }
    }

    private boolean loadGivenFile(String fileName, Properties p) {
        InputStream is;
        boolean loaded = false;
        try {
            is = BootstrapServer.class.getClassLoader().getResourceAsStream(fileName);
            try {
                if (is != null) {
                    p.load(is);
                    loaded = true;
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (!loaded) {
            try {
                is = new FileInputStream(fileName);
                try {
                    if (is != null) {
                        p.load(is);
                        loaded = true;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateApp() {
        block17: {
            File updateFile;
            try {
                Logger.info("Bootstrapper: Checking pre-downloaded update for tac-server.jar...");
                updateFile = new File("tac-server.jar-update");
                if (updateFile.exists()) {
                    Logger.info("Bootstrapper: Updating tac-server.jar...");
                    Files.copy(new File("tac-server.jar-update").toPath(), new File("tac-server.jar").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    if (!updateFile.delete()) {
                        updateFile.deleteOnExit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error(e);
            }
            try {
                Logger.info("Bootstrapper: Checking pre-downloaded update for tac-server bundle...");
                updateFile = new File("tac-server.zip-update");
                if (!updateFile.exists()) break block17;
                boolean isSuccess = false;
                String baseDir = System.getProperty("user.dir");
                Logger.info("Bootstrapper: Extracting tac-server.zip to: {}", baseDir);
                try (FileInputStream fileIS = new FileInputStream(updateFile);){
                    FileUnzipUtil.unzip(fileIS, baseDir);
                    isSuccess = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (isSuccess && !updateFile.delete()) {
                        updateFile.deleteOnExit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error(e);
            }
        }
    }

    private void startSpringBootApp() {
        try {
            while (true) {
                String commandLine = this.props.getProperty(BOOTSTRAP_SERVER_EXECUTE_COMMAND);
                List<String> commandsOrig = this.getCommands(commandLine);
                List<String> commands = new ArrayList<String>();
                boolean isDebug = false;
                for (String cmd : commandsOrig) {
                    if ("${DEBUG-OPTION}".equals(cmd)) {
                        if (this.args != null && this.args.length > 0) {
                            for (String a : this.args) {
                                if (a == null) continue;
                                if ("--debug".equals(a = a.toLowerCase()) || "-debug".equals(a) || "debug".equals(a)) {
                                    isDebug = true;
                                    continue;
                                }
                                if (!"--dev".equals(a) && !"-dev".equals(a) && !"dev".equals(a)) continue;
                                isDebug = true;
                            }
                        }
                        if (!isDebug) continue;
                        String debugOption = this.props.getProperty(BOOTSTRAP_SERVER_DEBUG_OPTION);
                        if (debugOption != null && debugOption.contains("${DYNAMIC-PORT}")) {
                            int port = 0;
                            try (ServerSocket serverSocket = new ServerSocket(port);){
                                port = serverSocket.getLocalPort();
                            }
                            catch (IOException e) {
                                port = 13000 + (int)(10000.0 * Math.random());
                            }
                            debugOption = debugOption.replace("${DYNAMIC-PORT}", "" + port);
                        }
                        commands.add(debugOption);
                        System.err.println("Using DEBUG option: " + debugOption);
                        Logger.warn("Using DEBUG option: {}", debugOption);
                        continue;
                    }
                    if ("${CLASSPATH}".equals(cmd)) {
                        if (tacServerId != null) {
                            commands.add("-Dtac-server-id=" + tacServerId);
                        }
                        StringBuilder classPaths = new StringBuilder().append("-Dloader.path=");
                        File patchRootDir = new File(System.getProperty("user.dir"), "patches" + File.separator + "server");
                        String patchClassPath = FileUtil.preparePatchClassPath(patchRootDir);
                        if (patchClassPath != null && patchClassPath.length() > 0) {
                            classPaths.append(patchClassPath);
                        }
                        classPaths.append("");
                        commands.add(classPaths.toString());
                        continue;
                    }
                    commands.add(cmd);
                }
                if (providedConfigFile != null) {
                    commands.add("--config=" + providedConfigFile);
                }
                commands.add("--started-via-bootstraper");
                if (isDebug) {
                    commands.add("--debug");
                }
                commands = this.resolveJavaPath(commands);
                Logger.info("Starting server via command line: {}", commands);
                this.serverProcess = new ProcessBuilder(commands).inheritIO().start();
                this.isAlive = this.serverProcess.isAlive();
                int exitCode = this.serverProcess.waitFor();
                Logger.error("Bootstrapper: TAC Server process completed with Exit Code: {}", exitCode);
                this.isAlive = this.serverProcess.isAlive();
                if (exitCode == 100) {
                    this.loadProperties();
                    Logger.info("Bootstrapper: Restarting the TAC Server...");
                    continue;
                }
                if (exitCode == 200) {
                    this.loadProperties();
                    this.updateApp();
                    continue;
                }
                break;
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private List<String> getCommands(String commandLine) {
        ArrayList<String> ret = new ArrayList<String>();
        String regex = "\"([^\"]*)\"|(\\S+)";
        Matcher m = Pattern.compile(regex).matcher(commandLine);
        while (m.find()) {
            if (m.group(1) != null) {
                ret.add(m.group(1));
                continue;
            }
            ret.add(m.group(2));
        }
        return ret;
    }

    private List<String> resolveJavaPath(List<String> commandArgs) {
        if (commandArgs == null || commandArgs.isEmpty()) {
            return commandArgs;
        }
        if (!this.isJavaCommand(commandArgs)) {
            return commandArgs;
        }
        String localJavaPath = this.findLocalJavaExecutable();
        if (localJavaPath == null) {
            Logger.debug("No local Java found, using system Java");
            return commandArgs;
        }
        Logger.info("Found local Java at: {}, using it instead of system Java", localJavaPath);
        return this.replaceJavaCommand(commandArgs, localJavaPath);
    }

    private boolean isJavaCommand(List<String> commandArgs) {
        if (commandArgs == null || commandArgs.isEmpty()) {
            return false;
        }
        if ("java".equals(commandArgs.get(0))) {
            return true;
        }
        if (commandArgs.size() >= 3) {
            String first = commandArgs.get(0);
            String second = commandArgs.get(1);
            String third = commandArgs.get(2);
            if ("bash".equals(first) && "-c".equals(second) || "cmd.exe".equals(first) && "/c".equals(second) || "cmd".equals(first) && "/c".equals(second)) {
                return third != null && third.startsWith("java ");
            }
        }
        return false;
    }

    private String findLocalJavaExecutable() {
        String parentDirJava;
        String currentDirJava = this.checkJavaInDirectory(System.getProperty("user.dir"));
        if (currentDirJava != null) {
            return currentDirJava;
        }
        File currentDir = new File(System.getProperty("user.dir"));
        String parentDir = currentDir.getParent();
        if (parentDir != null && (parentDirJava = this.checkJavaInDirectory(parentDir)) != null) {
            return parentDirJava;
        }
        return null;
    }

    private String checkJavaInDirectory(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File javaDir = new File(dirPath, "java");
        if (!javaDir.exists() || !javaDir.isDirectory()) {
            return null;
        }
        File binDir = new File(javaDir, "bin");
        if (!binDir.exists() || !binDir.isDirectory()) {
            return null;
        }
        File javaExe = new File(binDir, "java.exe");
        if (javaExe.exists() && javaExe.canExecute()) {
            return javaExe.getAbsolutePath();
        }
        File javaBin = new File(binDir, "java");
        if (javaBin.exists() && javaBin.canExecute()) {
            return javaBin.getAbsolutePath();
        }
        return null;
    }

    private List<String> replaceJavaCommand(List<String> commandArgs, String localJavaPath) {
        ArrayList<String> result = new ArrayList<String>(commandArgs);
        if (result.size() > 0 && "java".equals(result.get(0))) {
            result.set(0, localJavaPath);
            Logger.debug("Replaced direct java command with local Java: {}", localJavaPath);
            return result;
        }
        if (result.size() >= 3) {
            String commandString;
            String first = (String)result.get(0);
            String second = (String)result.get(1);
            String third = (String)result.get(2);
            if (("bash".equals(first) && "-c".equals(second) || "cmd.exe".equals(first) && "/c".equals(second) || "cmd".equals(first) && "/c".equals(second)) && (commandString = third).startsWith("java ")) {
                commandString = localJavaPath + commandString.substring(4);
                result.set(2, commandString);
                Logger.debug("Replaced java in shell command with local Java: {}", localJavaPath);
            }
        }
        return result;
    }
}

