/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tools.bootstrap;

import com.kumaran.tools.bootstrap.util.FileUnzipUtil;
import com.kumaran.tools.bootstrap.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinylog.Logger;

public class BootstrapAgent {
    private static final String BOOTSTRAP_AGENT_EXECUTE_COMMAND = "bootstrap.agent.$executeCommand$";
    private static final String BOOTSTRAP_AGENT_DEBUG_OPTION = "bootstrap.agent.debugOption";
    public static final int EXITCODE_NORMAL = 0;
    public static final int EXITCODE_RESTART = 100;
    public static final int EXITCODE_UPDATE = 200;
    private Process agentProcess = null;
    private boolean isAlive = false;
    private String[] args = null;
    private Properties props = null;
    private static String providedConfigFile = null;
    private static String givenAgentId = null;
    private static String instanceId = null;

    public static void main(String[] args) {
        for (String arg : args) {
            String value;
            if (!arg.startsWith("--spring.config.location") && !arg.startsWith("--config") || "agent.properties".equals(value = arg.substring(arg.indexOf("=") + 1))) continue;
            providedConfigFile = value;
        }
        BootstrapAgent bootstrap = new BootstrapAgent();
        bootstrap.start(args);
    }

    public void start(String[] args) {
        this.args = args;
        Thread shutdownHookThread = new Thread(){

            @Override
            public void run() {
                BootstrapAgent.this.shutdownHook();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        this.loadProperties();
        this.updateApp();
        this.startSpringBootApp();
    }

    private void shutdownHook() {
        if (this.agentProcess != null && this.agentProcess.isAlive()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.agentProcess.isAlive()) {
                if (this.tryGracefulAgentShutdown()) {
                    while (this.agentProcess.isAlive()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    this.agentProcess.destroy();
                }
            }
        }
    }

    private boolean tryGracefulAgentShutdown() {
        boolean ret = false;
        try {
            String agentURL = this.props.getProperty("agentUrlForFrameworks");
            if (agentURL != null) {
                URL url = new URL(agentURL + (agentURL.endsWith("/") ? "" : "/") + "admin/shutdown");
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                int responseCode = con.getResponseCode();
                Logger.info("Bootstrapper: Shutdown Response Code: {}", responseCode);
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuffer response = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    String status = response.toString();
                    Logger.info("Bootstrapper: Shutdown Response message: {}", status);
                    if ("success".equalsIgnoreCase(status)) {
                        ret = true;
                    }
                } else {
                    Logger.info("Bootstrapper: Shutdown request not worked");
                }
            }
        }
        catch (ConnectException ce) {
            Logger.error((Throwable)ce, "Bootstrapper: Can't connect to agent for initiating graceful shutting down. It may be already down.");
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
        return ret;
    }

    private void loadProperties() {
        Properties p = new Properties();
        boolean loaded = this.loadGivenFile("agent.properties", p);
        if (providedConfigFile != null) {
            loaded = this.loadGivenFile(providedConfigFile, p);
        }
        this.props = p;
        givenAgentId = this.props.getProperty("agent.agentId");
        instanceId = givenAgentId;
        if (instanceId == null || instanceId.isEmpty()) {
            SimpleDateFormat sdf = new SimpleDateFormat("DDDHHmmssSSS");
            instanceId = sdf.format(new Date());
        }
        System.out.println("Using Agent 'instance-id' as " + instanceId);
        if (!this.props.containsKey(BOOTSTRAP_AGENT_EXECUTE_COMMAND)) {
            this.props.put(BOOTSTRAP_AGENT_EXECUTE_COMMAND, "java ${DEBUG-OPTION} ${CLASSPATH} -cp tac-agent.jar org.springframework.boot.loader.PropertiesLauncher");
        }
        if (!this.props.containsKey(BOOTSTRAP_AGENT_DEBUG_OPTION)) {
            this.props.put(BOOTSTRAP_AGENT_DEBUG_OPTION, "-agentlib:jdwp=transport=dt_socket,address=0.0.0.0:12110,server=y,suspend=n");
        }
    }

    private boolean loadGivenFile(String fileName, Properties p) {
        InputStream is;
        boolean loaded = false;
        try {
            is = BootstrapAgent.class.getClassLoader().getResourceAsStream(fileName);
            try {
                if (is != null) {
                    p.load(is);
                    loaded = true;
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (!loaded) {
            try {
                is = new FileInputStream(fileName);
                try {
                    if (is != null) {
                        p.load(is);
                        loaded = true;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateApp() {
        block17: {
            File updateFile;
            try {
                Logger.info("Bootstrapper: Checking pre-downloaded update for tac-agent.jar...");
                updateFile = new File("tac-agent.jar-update");
                if (updateFile.exists()) {
                    Logger.info("Bootstrapper: Updating tac-agent.jar...");
                    Files.copy(new File("tac-agent.jar-update").toPath(), new File("tac-agent.jar").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    if (!updateFile.delete()) {
                        updateFile.deleteOnExit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error(e);
            }
            try {
                Logger.info("Bootstrapper: Checking pre-downloaded update for tac-agent bundle...");
                updateFile = new File("tac-agent.zip-update");
                if (!updateFile.exists()) break block17;
                boolean isSuccess = false;
                String baseDir = System.getProperty("user.dir");
                Logger.info("Bootstrapper: Extracting tac-agent.zip to: {}", baseDir);
                try (FileInputStream fileIS = new FileInputStream(updateFile);){
                    FileUnzipUtil.unzip(fileIS, baseDir);
                    isSuccess = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.error(e);
                }
                finally {
                    if (isSuccess && !updateFile.delete()) {
                        updateFile.deleteOnExit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error(e);
            }
        }
    }

    private void startSpringBootApp() {
        try {
            while (true) {
                String commandLine = this.props.getProperty(BOOTSTRAP_AGENT_EXECUTE_COMMAND);
                List<String> commandsOrig = this.getCommands(commandLine);
                List<String> commands = new ArrayList<String>();
                boolean isDebug = false;
                for (String cmd : commandsOrig) {
                    if ("${DEBUG-OPTION}".equals(cmd)) {
                        if (this.args != null && this.args.length > 0) {
                            for (String a : this.args) {
                                if (a == null) continue;
                                if ("--debug".equals(a = a.toLowerCase()) || "-debug".equals(a) || "debug".equals(a)) {
                                    isDebug = true;
                                    continue;
                                }
                                if (!"--dev".equals(a) && !"-dev".equals(a) && !"dev".equals(a)) continue;
                                isDebug = true;
                            }
                        }
                        if (!isDebug) continue;
                        String debugOption = this.props.getProperty(BOOTSTRAP_AGENT_DEBUG_OPTION);
                        if (debugOption != null && debugOption.contains("${DYNAMIC-PORT}")) {
                            int port = 0;
                            try (ServerSocket serverSocket = new ServerSocket(port);){
                                port = serverSocket.getLocalPort();
                            }
                            catch (IOException e) {
                                port = 13000 + (int)(10000.0 * Math.random());
                            }
                            debugOption = debugOption.replace("${DYNAMIC-PORT}", "" + port);
                        }
                        commands.add(debugOption);
                        System.err.println("Using DEBUG option: " + debugOption);
                        Logger.warn("Using DEBUG option: {}", debugOption);
                        continue;
                    }
                    if ("${CLASSPATH}".equals(cmd)) {
                        commands.add("-Dinstance-id=" + instanceId);
                        if (givenAgentId != null) {
                            commands.add("-Dagent-id=" + givenAgentId);
                        }
                        StringBuilder classPaths = new StringBuilder().append("-Dloader.path=");
                        File patchRootDir = new File(System.getProperty("user.dir"), "patches" + File.separator + "agent");
                        String patchClassPath = FileUtil.preparePatchClassPath(patchRootDir);
                        if (patchClassPath != null && patchClassPath.length() > 0) {
                            classPaths.append(patchClassPath);
                        }
                        classPaths.append("");
                        commands.add(classPaths.toString());
                        continue;
                    }
                    commands.add(cmd);
                }
                if (providedConfigFile != null) {
                    commands.add("--config=" + providedConfigFile);
                }
                commands.add("--started-via-bootstraper");
                if (isDebug) {
                    commands.add("--debug");
                }
                commands = this.resolveJavaPath(commands);
                Logger.info("Starting agent via command line: {}", commands);
                this.agentProcess = new ProcessBuilder(commands).inheritIO().start();
                this.isAlive = this.agentProcess.isAlive();
                int exitCode = this.agentProcess.waitFor();
                Logger.error("Bootstrapper: TAC Agent process completed with Exit Code: {}", exitCode);
                this.isAlive = this.agentProcess.isAlive();
                if (exitCode == 100) {
                    this.loadProperties();
                    Logger.info("Bootstrapper: Restarting the TAC Agent...");
                    continue;
                }
                if (exitCode == 200) {
                    this.loadProperties();
                    this.updateApp();
                    continue;
                }
                break;
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            Logger.error(e);
        }
    }

    private List<String> getCommands(String commandLine) {
        ArrayList<String> ret = new ArrayList<String>();
        String regex = "\"([^\"]*)\"|(\\S+)";
        Matcher m = Pattern.compile(regex).matcher(commandLine);
        while (m.find()) {
            if (m.group(1) != null) {
                ret.add(m.group(1));
                continue;
            }
            ret.add(m.group(2));
        }
        return ret;
    }

    private List<String> resolveJavaPath(List<String> commandArgs) {
        if (commandArgs == null || commandArgs.isEmpty()) {
            return commandArgs;
        }
        if (!this.isJavaCommand(commandArgs)) {
            return commandArgs;
        }
        String localJavaPath = this.findLocalJavaExecutable();
        if (localJavaPath == null) {
            Logger.debug("No local Java found, using system Java");
            return commandArgs;
        }
        Logger.info("Found local Java at: {}, using it instead of system Java", localJavaPath);
        return this.replaceJavaCommand(commandArgs, localJavaPath);
    }

    private boolean isJavaCommand(List<String> commandArgs) {
        if (commandArgs == null || commandArgs.isEmpty()) {
            return false;
        }
        if ("java".equals(commandArgs.get(0))) {
            return true;
        }
        if (commandArgs.size() >= 3) {
            String first = commandArgs.get(0);
            String second = commandArgs.get(1);
            String third = commandArgs.get(2);
            if ("bash".equals(first) && "-c".equals(second) || "cmd.exe".equals(first) && "/c".equals(second) || "cmd".equals(first) && "/c".equals(second)) {
                return third != null && third.startsWith("java ");
            }
        }
        return false;
    }

    private String findLocalJavaExecutable() {
        String parentDirJava;
        String currentDirJava = this.checkJavaInDirectory(System.getProperty("user.dir"));
        if (currentDirJava != null) {
            return currentDirJava;
        }
        File currentDir = new File(System.getProperty("user.dir"));
        String parentDir = currentDir.getParent();
        if (parentDir != null && (parentDirJava = this.checkJavaInDirectory(parentDir)) != null) {
            return parentDirJava;
        }
        return null;
    }

    private String checkJavaInDirectory(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File javaDir = new File(dirPath, "java");
        if (!javaDir.exists() || !javaDir.isDirectory()) {
            return null;
        }
        File binDir = new File(javaDir, "bin");
        if (!binDir.exists() || !binDir.isDirectory()) {
            return null;
        }
        File javaExe = new File(binDir, "java.exe");
        if (javaExe.exists() && javaExe.canExecute()) {
            return javaExe.getAbsolutePath();
        }
        File javaBin = new File(binDir, "java");
        if (javaBin.exists() && javaBin.canExecute()) {
            return javaBin.getAbsolutePath();
        }
        return null;
    }

    private List<String> replaceJavaCommand(List<String> commandArgs, String localJavaPath) {
        ArrayList<String> result = new ArrayList<String>(commandArgs);
        if (result.size() > 0 && "java".equals(result.get(0))) {
            result.set(0, localJavaPath);
            Logger.debug("Replaced direct java command with local Java: {}", localJavaPath);
            return result;
        }
        if (result.size() >= 3) {
            String commandString;
            String first = (String)result.get(0);
            String second = (String)result.get(1);
            String third = (String)result.get(2);
            if (("bash".equals(first) && "-c".equals(second) || "cmd.exe".equals(first) && "/c".equals(second) || "cmd".equals(first) && "/c".equals(second)) && (commandString = third).startsWith("java ")) {
                commandString = localJavaPath + commandString.substring(4);
                result.set(2, commandString);
                Logger.debug("Replaced java in shell command with local Java: {}", localJavaPath);
            }
        }
        return result;
    }
}

