/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.MasterAgentExecutor;
import com.kumaran.tac.agent.util.TestRunLogger;
import com.kumaran.tac.common.util.AutowireHelperUtil;
import com.kumaran.tac.common.util.CommonUtility;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRunLogger {
    private static final Logger logger = LoggerFactory.getLogger(TestRunLogger.class);
    private File TESTRUN_LOGS_FOLDER = null;
    private int testRunExecutionId;
    private String agentId;
    private String appenderName = null;
    private String fileName = null;
    private File logFile = null;
    private File lockFile = null;
    private LinkedBlockingQueue<File> filesToSend = null;
    private List<String> sentFiles = null;
    private FileUploader fileUploader = null;
    private TestRunLoggerExecutionStatus executionStatus = TestRunLoggerExecutionStatus.INIT;
    private static final Pattern LOC_FILE_PATTERN = Pattern.compile("TR_([0-9]+)\\.loc", 2);

    public static TestRunLogger getTestRunLogger(Integer n2, String string) {
        return TestRunLogger.getTestRunLogger((Integer)n2, (boolean)false, (String)string);
    }

    public static TestRunLogger getAndStartTestRunLogger(Integer n2, String string) {
        return TestRunLogger.getTestRunLogger((Integer)n2, (boolean)true, (String)string);
    }

    public static TestRunLogger getTestRunLogger(Integer n2, boolean bl, String string) {
        Map map = MasterAgentExecutor.getTestRunLoggerMap((String)string);
        TestRunLogger testRunLogger = (TestRunLogger)map.get(n2);
        if (testRunLogger == null) {
            logger.info("This is NOT AN ERROR. It is a debug message. testRunExecutionId : {}", (Object)n2, (Object)new Exception("Test run logger not found"));
            testRunLogger = new TestRunLogger(n2.intValue(), string);
            map.put(n2, testRunLogger);
        }
        if (bl) {
            testRunLogger.start();
        }
        return testRunLogger;
    }

    private TestRunLogger(int n2, String string) {
        Object object;
        this.testRunExecutionId = n2;
        this.agentId = string;
        this.appenderName = "Agent-" + string + "-TestRun-" + n2;
        this.fileName = "" + n2 + "_agent.log.txt";
        if (this.TESTRUN_LOGS_FOLDER == null) {
            object = "logs/" + string + "/testruns";
            this.TESTRUN_LOGS_FOLDER = new File(CommonUtility.getBaseDir(), (String)object);
            if (!this.TESTRUN_LOGS_FOLDER.exists()) {
                this.TESTRUN_LOGS_FOLDER.mkdirs();
            }
        }
        this.lockFile = new File(CommonUtility.getBaseDir(), "logs/" + string + "/TR_" + n2 + ".loc");
        this.filesToSend = new LinkedBlockingQueue();
        this.sentFiles = new ArrayList();
        object = new File(this.TESTRUN_LOGS_FOLDER, "" + n2);
        this.logFile = new File((File)object, this.fileName);
        logger.info("Logging the Test Run progress to {}, agentId :{}", (Object)this.logFile, (Object)string);
        this.fileUploader = new FileUploader(this, string);
        this.fileUploader.start();
    }

    public void sendFile(File file) {
        try {
            this.filesToSend.put(file);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Integer getTestRunExecutionId() {
        return this.testRunExecutionId;
    }

    public File getLogFolder() {
        return this.logFile.getParentFile();
    }

    private File createFolderUnderLogs(String string) {
        File file = new File(this.getLogFolder(), string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public File getMediaFolder() {
        return this.createFolderUnderLogs("media");
    }

    public File getUploadFolder() {
        return this.createFolderUnderLogs("uploads");
    }

    public File getDownloadsFolder() {
        return this.createFolderUnderLogs("downloads");
    }

    private void start() {
        if (this.executionStatus.isOnOrAfter(TestRunLoggerExecutionStatus.LOGGER_STARTED)) {
            return;
        }
        try {
            if (this.lockFile != null) {
                this.lockFile.createNewFile();
            }
        }
        catch (IOException iOException) {
            logger.warn("Can't create the lock file {}, agentId : {}", new Object[]{this.lockFile, this.agentId, iOException});
        }
        if (!this.logFile.getParentFile().exists()) {
            this.logFile.getParentFile().mkdirs();
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        PatternLayout patternLayout = PatternLayout.newBuilder().withConfiguration(configuration).withPattern("%d{ISO8601} [A:%X{agentId}] [%t] %-5level %logger{36}:%L - %msg%n").withAlwaysWriteExceptions(true).build();
        String string = this.logFile.getAbsolutePath();
        FileAppender.Builder builder = (FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withAppend(true).withBufferedIo(true)).withBufferSize(4096)).setConfiguration(configuration)).withFileName(string).setIgnoreExceptions(false)).withImmediateFlush(true)).setLayout((Layout)patternLayout)).withLocking(false).setName(this.appenderName);
        KeyValuePair[] keyValuePairArray = new KeyValuePair[]{new KeyValuePair("testRunExecutionId", "" + this.testRunExecutionId)};
        ThreadContextMapFilter threadContextMapFilter = ThreadContextMapFilter.createFilter((KeyValuePair[])keyValuePairArray, (String)"or", (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        builder.setFilter((Filter)threadContextMapFilter);
        FileAppender fileAppender = builder.build();
        fileAppender.start();
        configuration.addAppender((Appender)fileAppender);
        configuration.getLoggerConfig("").addAppender((Appender)fileAppender, null, null);
        logger.info("Logging the TestRunExecution #{} to file: {}, agentId : {}", new Object[]{this.testRunExecutionId, string, this.agentId});
        this.executionStatus = TestRunLoggerExecutionStatus.LOGGER_STARTED;
    }

    public void stop() {
        this.fileUploader.setQuitProcess(true);
        if (this.executionStatus.isOnOrAfter(TestRunLoggerExecutionStatus.LOGGER_STOPPED)) {
            return;
        }
        this.executionStatus = TestRunLoggerExecutionStatus.LOGGER_STOPPED;
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        logger.info("Stopping logging of the TestRunExecution #{},agentId : {}", (Object)this.testRunExecutionId, (Object)this.agentId);
        Appender appender = configuration.getAppender(this.appenderName);
        if (appender != null) {
            configuration.getLoggerConfig("").removeAppender(this.appenderName);
        }
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        new Thread((Runnable)var4_4).start();
    }

    private void sendLogs(List<String> list, String string) {
        logger.info("Compressing and sending logs to server.");
        try {
            AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
            agentService.saveLogs(this.getTestRunExecutionId(), null, list, false, string);
            this.executionStatus = TestRunLoggerExecutionStatus.SENT_TO_SERVER;
        }
        catch (Exception exception) {
            logger.error("Error sending logs to server", (Throwable)exception);
        }
    }

    private void partialFiles(List<String> list, List<String> list2, String string) {
        logger.info("Compressing and sending partial logs to server.");
        try {
            AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
            agentService.saveLogs(this.getTestRunExecutionId(), list, list2, true, string);
        }
        catch (Exception exception) {
            logger.error("Error sending partial logs to server", (Throwable)exception);
        }
    }

    public void deleteLockFile() {
        if (this.lockFile != null && this.lockFile.exists()) {
            if (!this.lockFile.delete()) {
                this.lockFile.deleteOnExit();
            }
            logger.info("Lock file {} is deleted", (Object)this.lockFile);
        } else {
            logger.warn("The lock file doesn't exists: {}", (Object)this.lockFile);
        }
    }

    public static void uploadOldTestRunLogs(String string, Map<Integer, TestRunLogger> map) {
        File file = new File(CommonUtility.getBaseDir(), "logs/" + string);
        logger.info("Finding any existing logs that are to be sent to server.");
        String[] stringArray = file.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                Matcher matcher = LOC_FILE_PATTERN.matcher(string2);
                if (!matcher.find()) continue;
                String string3 = matcher.group(1);
                int n2 = Integer.parseInt(string3);
                logger.info("Sendings logs of TestRunExecution #{} to server", (Object)n2);
                TestRunLogger testRunLogger = map.get(n2);
                if (testRunLogger == null) continue;
                testRunLogger.sendLogs(null, string);
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            logger.info("No logs to be sent to server.");
        } else {
            logger.info("Logs are sent to server.");
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ int access$100(TestRunLogger testRunLogger) {
        return testRunLogger.testRunExecutionId;
    }

    static /* synthetic */ LinkedBlockingQueue access$200(TestRunLogger testRunLogger) {
        return testRunLogger.filesToSend;
    }

    static /* synthetic */ List access$300(TestRunLogger testRunLogger) {
        return testRunLogger.sentFiles;
    }

    static /* synthetic */ void access$400(TestRunLogger testRunLogger, List list, List list2, String string) {
        testRunLogger.partialFiles(list, list2, string);
    }

    static /* synthetic */ String access$500(TestRunLogger testRunLogger) {
        return testRunLogger.agentId;
    }

    static /* synthetic */ File access$600(TestRunLogger testRunLogger) {
        return testRunLogger.logFile;
    }

    static /* synthetic */ FileUploader access$700(TestRunLogger testRunLogger) {
        return testRunLogger.fileUploader;
    }

    static /* synthetic */ void access$800(TestRunLogger testRunLogger, List list, String string) {
        testRunLogger.sendLogs(list, string);
    }

    static /* synthetic */ Pattern access$900() {
        return LOC_FILE_PATTERN;
    }
}

