/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.jhlabs.image.GaussianFilter;
import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.ScreenVideoUtil;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.agent.util.TestRunLogger;
import com.kumaran.tac.common.enums.TestStepStatus;
import com.kumaran.tac.common.util.FileUtil;
import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ScreenVideoUtil {
    private static final Logger logger = LoggerFactory.getLogger(ScreenVideoUtil.class);
    @Autowired
    AgentService agentService;
    static final Map<Integer, TestStepStatus> stepStatusMap = new ConcurrentHashMap();
    static final Map<Integer, LinkedBlockingQueue<Thread>> testRunVideoThreadMap = new ConcurrentHashMap();
    int videoSeqNo = 1;
    TacScreenRecorder screenRecorder = null;

    public static void setStepStatus(Integer n2, TestStepStatus testStepStatus) {
        stepStatusMap.put(n2, testStepStatus);
    }

    public static void closeAllRunningAsCompleted(TestStepStatus testStepStatus) {
        for (Map.Entry entry : stepStatusMap.entrySet()) {
            if (entry.getValue() != null && !((TestStepStatus)entry.getValue()).isIncompleteStatus()) continue;
            entry.setValue(testStepStatus);
        }
    }

    public static void addVideoThread(Integer n3, Thread thread) {
        LinkedBlockingQueue linkedBlockingQueue = testRunVideoThreadMap.computeIfAbsent(n3, n2 -> new LinkedBlockingQueue());
        linkedBlockingQueue.add(thread);
    }

    public static void waitForVideoThreadsToComplete(Integer n2) {
        if (testRunVideoThreadMap.containsKey(n2)) {
            LinkedBlockingQueue linkedBlockingQueue = (LinkedBlockingQueue)testRunVideoThreadMap.get(n2);
            ArrayList arrayList = new ArrayList();
            linkedBlockingQueue.drainTo(arrayList);
            for (Thread thread : arrayList) {
                if (!thread.isAlive()) continue;
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    logger.error("Error joining the video conversion thread.", (Throwable)interruptedException);
                }
            }
        }
    }

    public synchronized void startRecording(ScreenRecorderConfig screenRecorderConfig) {
        this.stopRecording();
        String string = "Video-Step-" + (screenRecorderConfig.getTestRunDetailId() != null ? screenRecorderConfig.getTestRunDetailId() : "0");
        Integer n2 = LoadConfigFile.getInstance().getPropertyAsIntger("max-video-duration-in-secs", Integer.valueOf(300));
        int n3 = TestRunExecutionData.getCurrentTestRunExecutionId();
        try {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            File file = TestRunLogger.getTestRunLogger((Integer)screenRecorderConfig.getTestRunExecutionId(), (String)LoadConfigFile.getAgentId()).getMediaFolder();
            logger.info("Starting screen recording: {}/{}", (Object)file, (Object)string);
            this.screenRecorder = new TacScreenRecorder(graphicsConfiguration, null, new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "jpeg", VideoFormatKeys.CompressorNameKey, "jpeg", VideoFormatKeys.DepthKey, 24, FormatKeys.FrameRateKey, Rational.valueOf((double)15.0), VideoFormatKeys.QualityKey, Float.valueOf(1.0f), FormatKeys.KeyFrameIntervalKey, 900}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "black", FormatKeys.FrameRateKey, Rational.valueOf((double)30.0)}), null, file);
            this.screenRecorder.setMaxRecordingTime((long)(n2 * 1000));
            this.screenRecorder.setConfig(screenRecorderConfig);
            this.screenRecorder.setFileName(string);
            stepStatusMap.putIfAbsent(screenRecorderConfig.getTestRunDetailId(), TestStepStatus.NULL);
            this.screenRecorder.start();
            ++this.videoSeqNo;
        }
        catch (Exception exception) {
            logger.error("Error recording screen", (Throwable)exception);
        }
    }

    public synchronized void stopRecording() {
        if (this.screenRecorder != null) {
            TacScreenRecorder tacScreenRecorder = this.screenRecorder;
            int n2 = TestRunExecutionData.getCurrentTestRunExecutionId();
            String string = LoadConfigFile.getAgentId();
            Thread thread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            ScreenVideoUtil.addVideoThread((Integer)n2, (Thread)thread);
            thread.start();
            this.screenRecorder = null;
        }
    }

    public CompressedFileInfo getScreenshot(Integer n2, String string, boolean bl, String string2) {
        CompressedFileInfo compressedFileInfo = new CompressedFileInfo();
        TestRunLogger testRunLogger = TestRunLogger.getTestRunLogger((Integer)n2, (String)LoadConfigFile.getAgentId());
        File file = testRunLogger.getMediaFolder();
        try {
            File file2 = null;
            file2 = string2 != null ? new File(string2) : FileUtil.getScreenshotFileName((File)file, (String)string, (boolean)true);
            File file3 = FileUtil.getScreenshotFileName((File)file, (String)string, (boolean)false);
            if (file2.exists()) {
                file3 = file2;
                if (bl && this.blurImage(file3, file3) != null) {
                    logger.error("Unable to blur the image {}", (Object)file3);
                }
            } else {
                ByteArrayOutputStream byteArrayOutputStream = this.getScreenshot(bl);
                Files.write(file3.toPath(), byteArrayOutputStream.toByteArray(), StandardOpenOption.CREATE);
            }
            testRunLogger.sendFile(file3);
            compressedFileInfo.data = new byte[0];
            compressedFileInfo.uncompressedSize = 0L;
            compressedFileInfo.compressedSize = compressedFileInfo.data.length;
        }
        catch (Exception exception) {
            FileUtil.createStandardErrorFile((File)file, (String)(string + "-Exception"));
            logger.error("Error taking screenshot", (Throwable)exception);
        }
        return compressedFileInfo;
    }

    public ByteArrayOutputStream getScreenshot(boolean bl) throws AWTException, IOException {
        System.setProperty("java.awt.headless", "false");
        Robot robot = new Robot();
        Rectangle rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        BufferedImage bufferedImage = robot.createScreenCapture(rectangle);
        if (bl) {
            bufferedImage = this.blurImage(bufferedImage);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream;
    }

    private BufferedImage blurImage(File file, File file2) {
        try {
            BufferedImage bufferedImage = this.blurImage(ImageIO.read(file));
            if (file2 != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
                byteArrayOutputStream.close();
                Files.write(file2.toPath(), byteArrayOutputStream.toByteArray(), StandardOpenOption.CREATE);
            }
            return bufferedImage;
        }
        catch (IOException iOException) {
            logger.error("Unable to read image", (Throwable)iOException);
            return null;
        }
    }

    private BufferedImage blurImage(BufferedImage bufferedImage) {
        GaussianFilter gaussianFilter = new GaussianFilter(15.0f);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        gaussianFilter.filter(bufferedImage, bufferedImage2);
        bufferedImage = bufferedImage2;
        return bufferedImage;
    }

    public static void main1(String[] stringArray) {
        ScreenVideoUtil screenVideoUtil = new ScreenVideoUtil();
        ScreenRecorderConfig screenRecorderConfig = new ScreenRecorderConfig();
        screenRecorderConfig.setTestRunDetailId(Integer.valueOf(0));
        screenRecorderConfig.setLocalRecordExecution(true);
        screenRecorderConfig.setLocalRecordFailureOnly(false);
        screenRecorderConfig.setLocalRetainRecording(true);
        screenVideoUtil.startRecording(screenRecorderConfig);
        try {
            Thread.sleep(35000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        ScreenVideoUtil.setStepStatus((Integer)0, (TestStepStatus)TestStepStatus.PASSED);
        screenVideoUtil.stopRecording();
    }

    public static void main(String[] stringArray) throws Exception {
        ScreenVideoUtil screenVideoUtil = new ScreenVideoUtil();
        ByteArrayOutputStream byteArrayOutputStream = screenVideoUtil.getScreenshot(true);
        File file = new File("d:/temp/blurred.jpg");
        Files.write(file.toPath(), byteArrayOutputStream.toByteArray(), StandardOpenOption.CREATE);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

