/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.AgentApplication;
import com.kumaran.tac.agent.util.FrameworkQueueDetails;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.MasterAgentExecutor;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.messages.MessageUtils;
import com.kumaran.tac.common.util.CommonUtility;
import com.kumaran.tac.framework.common.util.FrameworkSpringConfiguration;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestUtil {
    private static final Logger logger = LoggerFactory.getLogger(RestUtil.class);
    private HttpComponentsClientHttpRequestFactory cachedRequestFactory;
    private String serverWebURL = null;
    private String agentId = null;
    private String authToken = null;
    private boolean serverAccessErrorLogged = false;
    private boolean isAuthenticationCall = false;
    private static final Map<String, Object> EMPTY_URI_VARIABLES = new HashMap();

    public boolean wasServerAccessFailed() {
        return this.serverAccessErrorLogged;
    }

    public void refresh() {
        this.serverWebURL = null;
        this.authToken = null;
        this.cachedRequestFactory = null;
    }

    public boolean isAuthenticated() {
        return this.authToken != null;
    }

    private HttpComponentsClientHttpRequestFactory prepare(String string2) {
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = null;
        boolean bl = true;
        if (this.isFullUrl(string2)) {
            bl = false;
        }
        if (bl && this.cachedRequestFactory != null) {
            httpComponentsClientHttpRequestFactory = this.cachedRequestFactory;
            return httpComponentsClientHttpRequestFactory;
        }
        try {
            LoadConfigFile loadConfigFile;
            String string3 = this.serverWebURL = LoadConfigFile.getInstance().getServerUrl();
            if (!bl) {
                string3 = string2;
            }
            this.agentId = LoadConfigFile.getAgentId();
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            if (string3 != null && string3.startsWith("https://")) {
                Object object;
                loadConfigFile = LoadConfigFile.getInstance();
                String string4 = loadConfigFile.getPropertyAsString("agent.trust-store");
                String string5 = loadConfigFile.getPropertyAsString("agent.trust-store-password");
                SSLContextBuilder sSLContextBuilder = SSLContexts.custom();
                if (string4 == null || string4.isEmpty() || string5 == null || string5.isEmpty()) {
                    sSLContextBuilder = sSLContextBuilder.loadTrustMaterial(null, (x509CertificateArray, string) -> true);
                } else {
                    object = new File(string4);
                    if (!((File)object).exists()) {
                        throw new TACException(MessageUtils.getMessage((String)"CERTIFICATE_OR_PASSWORD_NOT_FOUND"));
                    }
                    if (string5 != null && string5.length() > 0 && string5.startsWith("ENC(") && string5.endsWith(")")) {
                        string5 = string5.substring("ENC(".length(), string5.length() - 1);
                        string5 = FrameworkSpringConfiguration.stringEncryptor().decrypt(string5);
                    }
                    sSLContextBuilder = sSLContextBuilder.loadTrustMaterial((File)object, string5.toCharArray(), (x509CertificateArray, string) -> true);
                }
                object = sSLContextBuilder.build();
                SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory((SSLContext)object, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                httpClientBuilder = httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sSLConnectionSocketFactory);
            }
            httpClientBuilder.useSystemProperties();
            httpClientBuilder.setMaxConnPerRoute(50).setMaxConnTotal(50);
            loadConfigFile = httpClientBuilder.build();
            httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
            httpComponentsClientHttpRequestFactory.setHttpClient((HttpClient)loadConfigFile);
            httpComponentsClientHttpRequestFactory.setBufferRequestBody(false);
            httpComponentsClientHttpRequestFactory.setConnectTimeout(600000);
            httpComponentsClientHttpRequestFactory.setReadTimeout(600000);
            if (bl) {
                this.cachedRequestFactory = httpComponentsClientHttpRequestFactory;
            }
        }
        catch (Exception exception) {
            logger.error("Exception in preparation.", (Throwable)exception);
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
        return httpComponentsClientHttpRequestFactory;
    }

    private RestTemplate getRestTemplate(String string) {
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = this.prepare(string);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        return restTemplate;
    }

    public HttpHeaders getStandardHeaders(HttpHeaders httpHeaders) {
        HttpHeaders httpHeaders2 = new HttpHeaders();
        if (httpHeaders != null) {
            httpHeaders.forEach((string, list) -> httpHeaders2.addAll(string, list));
        }
        if (httpHeaders2.getAccept() == null || httpHeaders2.getAccept().isEmpty()) {
            httpHeaders2.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        }
        if (httpHeaders2.getContentType() == null) {
            httpHeaders2.setContentType(MediaType.APPLICATION_JSON);
        }
        if (this.authToken != null) {
            httpHeaders2.set("Authorization", "Bearer " + this.authToken);
        }
        return httpHeaders2;
    }

    public <T> T getData(String string, Class<T> clazz) {
        ResponseEntity responseEntity = this.getDataResponseEntity(string, clazz, EMPTY_URI_VARIABLES);
        if (responseEntity == null) {
            return null;
        }
        return (T)responseEntity.getBody();
    }

    public <T> T getData(String string, Class<T> clazz, Map<String, Object> map) {
        ResponseEntity responseEntity = this.getDataResponseEntity(string, clazz, map);
        if (responseEntity == null) {
            return null;
        }
        return (T)responseEntity.getBody();
    }

    public <T> ResponseEntity<T> getDataResponseEntity(String string, Class<T> clazz) {
        return this.getDataResponseEntity(string, clazz, EMPTY_URI_VARIABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ResponseEntity<T> getDataResponseEntity(String string, Class<T> clazz, Map<String, Object> map) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        long l2 = System.currentTimeMillis();
        boolean bl = string.contains("/tre/");
        boolean bl2 = false;
        try {
            RestTemplate restTemplate;
            int n2 = 2;
            while (n2 > 0) {
                ResponseEntity responseEntity;
                this.authenticate();
                restTemplate = this.getRestTemplate(string);
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.getStandardHeaders(null));
                ResponseEntity responseEntity2 = null;
                try {
                    responseEntity2 = restTemplate.exchange(this.getUrl(string), HttpMethod.GET, httpEntity, clazz, map);
                    if (this.serverAccessErrorLogged) {
                        logger.warn("Successfully connected back to server.");
                        responseEntity = MasterAgentExecutor.getAgentExecutor((String)LoadConfigFile.getAgentId());
                        if (responseEntity != null) {
                            AgentApplication.checkVersionUpgrade((boolean)true);
                        }
                    }
                    this.serverAccessErrorLogged = false;
                    if (testRunExecutionData.isSendAbortFlag()) {
                        this.sendServerDownAbortMessage();
                    }
                    if (this.retryAuthentication(responseEntity2)) {
                        --n2;
                        continue;
                    }
                }
                catch (HttpClientErrorException httpClientErrorException) {
                    logger.error("Http Client error", (Throwable)httpClientErrorException);
                    bl2 = true;
                    if (this.retryAuthentication(httpClientErrorException)) {
                        --n2;
                        continue;
                    }
                    if (!testRunExecutionData.isSendAbortFlag()) {
                        this.abortAllQueueProcess();
                    }
                }
                catch (ResourceAccessException resourceAccessException) {
                    bl2 = true;
                    if (!this.serverAccessErrorLogged) {
                        logger.error("Server access error", (Throwable)resourceAccessException);
                        this.serverAccessErrorLogged = true;
                        this.abortAllQueueProcess();
                    }
                }
                catch (Exception exception) {
                    if (exception.getMessage() != null) {
                        if (!(exception.getMessage().contains("Error getting next text value") || exception.getMessage().contains("reference") || exception.getMessage().contains("Unable") || exception.getMessage().contains("ReferenceData"))) {
                            bl2 = true;
                        }
                    }
                    bl2 = true;
                }
                responseEntity = responseEntity2;
                return responseEntity;
            }
            restTemplate = null;
            return restTemplate;
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            testRunExecutionData.addTotalNetworkTime(l3);
            if (bl2 && bl) {
                this.abortTestRun();
                TestRunExecutionData.setCurrentTestRunExecutionId((int)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> File download(String string, HttpMethod httpMethod, Path path, Map<String, Object> map, T t2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        long l2 = System.currentTimeMillis();
        boolean bl = string.contains("/tre/");
        boolean bl2 = false;
        try {
            RestTemplate restTemplate;
            int n2 = 2;
            while (n2 > 0) {
                HttpEntity httpEntity;
                this.authenticate();
                restTemplate = this.getRestTemplate(string);
                Object object = null;
                HttpStatus[] httpStatusArray = new HttpStatus[]{null};
                try {
                    httpEntity = new HttpEntity(t2, (MultiValueMap)this.getStandardHeaders(null));
                    RequestCallback requestCallback = restTemplate.httpEntityCallback((Object)httpEntity);
                    object = (File)restTemplate.execute(this.getUrl(string), httpMethod, requestCallback, clientHttpResponse -> {
                        httpStatusArray[0] = clientHttpResponse.getStatusCode();
                        path.getParent().toFile().mkdirs();
                        File file = path.toFile();
                        if (file.exists()) {
                            file.delete();
                        }
                        Files.copy(clientHttpResponse.getBody(), path, StandardCopyOption.REPLACE_EXISTING);
                        return file;
                    }, map == null ? EMPTY_URI_VARIABLES : map);
                    if (this.serverAccessErrorLogged) {
                        logger.warn("Successfully connected back to server.");
                    }
                    this.serverAccessErrorLogged = false;
                    if (testRunExecutionData.isSendAbortFlag()) {
                        this.sendServerDownAbortMessage();
                    }
                    if (this.retryAuthentication(httpStatusArray[0])) {
                        --n2;
                        continue;
                    }
                }
                catch (HttpClientErrorException httpClientErrorException) {
                    logger.error("Http Client error", (Throwable)httpClientErrorException);
                    bl2 = true;
                    if (this.retryAuthentication(httpClientErrorException)) {
                        --n2;
                        continue;
                    }
                    if (!testRunExecutionData.isSendAbortFlag()) {
                        this.abortAllQueueProcess();
                    }
                }
                catch (ResourceAccessException resourceAccessException) {
                    bl2 = true;
                    if (!this.serverAccessErrorLogged) {
                        logger.error("Server access error", (Throwable)resourceAccessException);
                        this.serverAccessErrorLogged = true;
                        this.abortAllQueueProcess();
                    }
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                httpEntity = object;
                return httpEntity;
            }
            restTemplate = null;
            return restTemplate;
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            testRunExecutionData.addTotalNetworkTime(l3);
            if (bl2 && bl) {
                this.abortTestRun();
                TestRunExecutionData.setCurrentTestRunExecutionId((int)0);
            }
        }
    }

    public <T> T postData(String string, Object object, Class<T> clazz) {
        return (T)this.postData(string, object, clazz, EMPTY_URI_VARIABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T postData(String string, Object object, Class<T> clazz, Map<String, Object> map) throws HttpClientErrorException {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        int n2 = testRunExecutionData.getTestRunExecutionId();
        long l2 = System.currentTimeMillis();
        boolean bl = string.contains("/tre/");
        boolean bl2 = false;
        try {
            RestTemplate restTemplate;
            int n3 = 2;
            while (n3 > 0) {
                Object object2;
                this.authenticate();
                restTemplate = this.getRestTemplate(string);
                HttpEntity httpEntity = null;
                httpEntity = object instanceof HttpEntity ? (HttpEntity)object : new HttpEntity(object, (MultiValueMap)this.getStandardHeaders(null));
                ResponseEntity responseEntity = null;
                try {
                    if (clazz != null) {
                        responseEntity = restTemplate.exchange(this.getUrl(string), HttpMethod.POST, httpEntity, clazz, map);
                    } else {
                        restTemplate.exchange(this.getUrl(string), HttpMethod.POST, httpEntity, Void.class, map);
                    }
                    if (this.serverAccessErrorLogged) {
                        logger.warn("Successfully connected back to server.");
                    }
                    if (testRunExecutionData.isSendAbortFlag()) {
                        this.sendServerDownAbortMessage();
                    }
                    this.serverAccessErrorLogged = false;
                    if (this.isAuthenticationCall) {
                        if (responseEntity.getStatusCode().isError()) {
                            throw new TACException("AGENT_AUTHENTICATION_FAILED", "Failure in Agent Authentication.");
                        }
                    } else if (this.retryAuthentication(responseEntity)) {
                        --n3;
                        continue;
                    }
                }
                catch (HttpClientErrorException httpClientErrorException) {
                    bl2 = true;
                    logger.error("Http Client error", (Throwable)httpClientErrorException);
                    if (this.retryAuthentication(httpClientErrorException)) {
                        --n3;
                        continue;
                    }
                    if (!testRunExecutionData.isSendAbortFlag()) {
                        this.abortAllQueueProcess();
                    }
                }
                catch (ResourceAccessException resourceAccessException) {
                    bl2 = true;
                    if (!this.serverAccessErrorLogged) {
                        logger.error("Server access error", (Throwable)resourceAccessException);
                        this.serverAccessErrorLogged = true;
                        this.abortAllQueueProcess();
                    }
                    if (this.isAuthenticationCall) {
                        throw resourceAccessException;
                    }
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                if (clazz != null && clazz.isAssignableFrom(ResponseEntity.class)) {
                    object2 = responseEntity;
                    return (T)object2;
                }
                if (responseEntity == null) {
                    object2 = null;
                    return (T)object2;
                }
                object2 = responseEntity.getBody();
                return (T)object2;
            }
            restTemplate = null;
            return (T)restTemplate;
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            testRunExecutionData.addTotalNetworkTime(l3);
            if (bl2 && bl) {
                this.abortTestRun();
                TestRunExecutionData.setCurrentTestRunExecutionId((int)0);
            }
        }
    }

    private void abortAllQueueProcess() {
        FrameworkQueueDetails frameworkQueueDetails = MasterAgentExecutor.getFrameworkQueueDetails((String)LoadConfigFile.getAgentId());
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        if (frameworkQueueDetails.isAnyTestrunRunning()) {
            testRunExecutionData.setSendAbortFlag(true);
            frameworkQueueDetails.abortAllQueuedProcess();
        }
    }

    private void sendServerDownAbortMessage() {
        FrameworkQueueDetails frameworkQueueDetails = MasterAgentExecutor.getFrameworkQueueDetails((String)LoadConfigFile.getAgentId());
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        testRunExecutionData.setSendAbortFlag(false);
        frameworkQueueDetails.abortTestRun(true, "Server went down");
    }

    private boolean retryAuthentication(ResponseEntity responseEntity) {
        if (responseEntity != null) {
            return this.retryAuthentication(responseEntity.getStatusCode());
        }
        return false;
    }

    private boolean retryAuthentication(HttpStatus httpStatus) {
        if (httpStatus != null && httpStatus.value() == 401 && "User.Session.Expired".equals(httpStatus.getReasonPhrase())) {
            this.authToken = null;
            return true;
        }
        return false;
    }

    private boolean retryAuthentication(HttpClientErrorException httpClientErrorException) {
        if (httpClientErrorException instanceof HttpClientErrorException.Unauthorized) {
            HttpClientErrorException.Unauthorized unauthorized = (HttpClientErrorException.Unauthorized)httpClientErrorException;
            String string = unauthorized.getMessage();
            if (unauthorized.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                this.authToken = null;
                return true;
            }
            if (string != null && string.contains("User.Session.Expired")) {
                this.authToken = null;
                return true;
            }
        }
        return false;
    }

    public boolean isFullUrl(String string) {
        return string != null && string.matches("https?://.*");
    }

    public String getUrl(String string) {
        if (this.isFullUrl(string)) {
            return string;
        }
        return this.serverWebURL + (this.serverWebURL.endsWith("/") ? "" : "/") + "v1" + (string.startsWith("/") ? "" : "/") + string;
    }

    public void authenticateIfNecessary() {
        this.authenticate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate() {
        if (this.authToken != null) {
            return;
        }
        if (this.isAuthenticationCall) {
            return;
        }
        this.getRestTemplate(null);
        if (this.serverWebURL == null || this.agentId == null) {
            return;
        }
        this.isAuthenticationCall = true;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("loginId", "agent:" + this.agentId);
            hashMap.put("password", CommonUtility.digestAsHex((String)("" + this.agentId)));
            String string = LoadConfigFile.getInstance().getPropertyAsString("agent.tenantId");
            hashMap.put("tenantId", string);
            Calendar calendar = Calendar.getInstance();
            int n2 = (calendar.get(15) + calendar.get(16)) / 60000;
            hashMap.put("timezoneOffset", n2);
            HttpEntity httpEntity = new HttpEntity(hashMap);
            if (!this.serverAccessErrorLogged) {
                logger.info("Authenticating to {}, with Tenant Id {}", (Object)this.serverWebURL, (Object)string);
            }
            String string2 = this.serverWebURL + (this.serverWebURL.endsWith("/") ? "" : "/") + "authenticate";
            boolean bl = false;
            boolean bl2 = false;
            String string3 = null;
            Map map = null;
            try {
                map = (Map)this.postData(string2, (Object)httpEntity, Map.class);
            }
            catch (ResourceAccessException resourceAccessException) {
                bl2 = true;
                if (!this.serverAccessErrorLogged) {
                    logger.error("Server access error", (Throwable)resourceAccessException);
                    this.serverAccessErrorLogged = true;
                }
            }
            catch (Exception exception) {
                logger.error("Error in authenticating agent.", (Throwable)exception);
            }
            if (!bl2) {
                if (map != null) {
                    this.authToken = (String)map.get("JWT_TOKEN");
                    if (this.authToken == null) {
                        string3 = map.getOrDefault("status", "Error");
                    }
                } else {
                    bl = true;
                }
                if (bl || "Error".equals(string3)) {
                    logger.error("Error authenticating agent against the server. Status={}. Quitting.", string3);
                    AgentApplication.shutdown((int)0);
                }
            }
        }
        finally {
            this.isAuthenticationCall = false;
        }
    }

    public static boolean isLocalRequest(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRemoteAddr();
        if (httpServletRequest.getHeader("X-Forwarded-For") != null) {
            string = httpServletRequest.getHeader("X-Forwarded-For");
        }
        return "localhost".equals(string) || "127.0.0.1".equals(string);
    }

    public void resetNetworkTiming() {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        logger.info("Resetting Network Timing (call to server). Network Timing was: {}", (Object)testRunExecutionData.getTotalNetworkTime());
        testRunExecutionData.setTotalNetworkTime(0L);
    }

    public long getNetworkTiming() {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return testRunExecutionData.getTotalNetworkTime();
    }

    private void abortTestRun() {
        String string = "ABORT_MESSAGE_GENERAL_EXCEPTION";
        FrameworkQueueDetails frameworkQueueDetails = MasterAgentExecutor.getFrameworkQueueDetails((String)LoadConfigFile.getAgentId());
        frameworkQueueDetails.abortTestRun(true, MessageUtils.getMessage((String)string));
        logger.error("Exception caught in AgentService: {}", (Object)string);
    }
}

