/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.agent.util.TestRunLogger;
import com.kumaran.tac.common.dto.UploadFileExecutionDTO;
import com.kumaran.tac.common.dto.ValidationModel;
import com.kumaran.tac.common.util.CompressionUtil;
import com.kumaran.tac.common.util.FileUnzipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RemoteFileDownloader
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(RemoteFileDownloader.class);
    @Autowired
    RestUtil restUtil;
    @Autowired
    AgentService agentService;
    FileUnzipUtil fileUnzipUtil;
    ValidationModel validationModel;
    private int fileId;
    private String fileName;
    private boolean isCompleted;
    private String filePath;
    private boolean compressed;
    private int testRunExecutionId;
    private String agentId;

    public int getFileId() {
        return this.fileId;
    }

    public void setFileId(int n2) {
        this.fileId = n2;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean bl) {
        this.isCompleted = bl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean bl) {
        this.compressed = bl;
    }

    public int getTestRunExecutionId() {
        return this.testRunExecutionId;
    }

    public void setTestRunExecutionId(int n2) {
        this.testRunExecutionId = n2;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String string) {
        this.agentId = string == null ? "" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TestRunExecutionData.setCurrentTestRunExecutionId((int)this.testRunExecutionId);
        this.isCompleted = false;
        LoadConfigFile.setAgentId((String)this.agentId);
        String string = String.format("/tre/files/%d/remoteFile", this.fileId);
        try {
            File file;
            File file2;
            if (this.filePath == null) {
                file2 = TestRunLogger.getTestRunLogger((Integer)this.testRunExecutionId, (String)this.agentId).getUploadFolder();
                file = new File(file2.getAbsoluteFile(), String.valueOf(this.fileId));
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.filePath = file.getAbsolutePath();
            }
            this.filePath = this.filePath + File.separator + this.fileName;
            file2 = this.restUtil.download(string, HttpMethod.GET, Paths.get(this.filePath, new String[0]), null, null);
            if (file2 != null && file2.exists() && this.isCompressed()) {
                file = CompressionUtil.decompressFile((File)file2);
                this.filePath = file.getAbsolutePath();
            }
            logger.info("Remote file : {} obtained from the server and placed in {}", (Object)this.fileId, (Object)this.filePath);
        }
        catch (Exception exception) {
            logger.error("Error occurred while obtaining the remote file : {}", (Object)this.fileId, (Object)exception);
        }
        finally {
            this.isCompleted = true;
        }
    }

    public void filedownLoad(List<UploadFileExecutionDTO> list, String string) {
        TestRunExecutionData.setCurrentTestRunExecutionId((int)this.testRunExecutionId);
        LoadConfigFile.setAgentId((String)this.agentId);
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                UploadFileExecutionDTO uploadFileExecutionDTO = list.get(i2);
                String string2 = String.format("/tre/files/%d/remoteFile", uploadFileExecutionDTO.getFileId());
                Boolean bl = uploadFileExecutionDTO.isExtractInd();
                File file = this.restUtil.download(string2, HttpMethod.GET, Paths.get(string, uploadFileExecutionDTO.getFileName()), null, null);
                logger.info("Remote file : {} ({}) obtained from the server and placed in {}", new Object[]{uploadFileExecutionDTO.getFileId(), uploadFileExecutionDTO.getFileName(), file});
                if (file == null || !file.exists() || bl == null || !Boolean.TRUE.equals(bl)) continue;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    FileUnzipUtil.unzip((InputStream)fileInputStream, (String)string, (boolean)false, (boolean)false);
                    logger.info("Remote file : {} ({}) extracted to {}", new Object[]{uploadFileExecutionDTO.getFileId(), uploadFileExecutionDTO.getFileName(), string});
                    continue;
                }
            }
        }
        catch (Exception exception) {
            logger.error("Error occurred while obtaining the remote file : {}", (Object)this.fileId, (Object)exception);
        }
    }
}

