/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.util.AgentExecutor;
import com.kumaran.tac.agent.util.AsyncUpdaterThread;
import com.kumaran.tac.agent.util.FrameworkQueueDetails;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.agent.util.TestRunLogger;
import com.kumaran.tac.common.actions.DQVAction;
import com.kumaran.tac.common.communication.commands.BaseCommand;
import com.kumaran.tac.common.enums.Browser;
import com.kumaran.tac.common.util.AutowireHelperUtil;
import com.kumaran.tac.common.util.ClassPathUtil;
import com.kumaran.tac.common.windows.WindowsBrowserUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MasterAgentExecutor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MasterAgentExecutor.class);
    private static boolean serverUrlExists = false;
    @Autowired
    @Qualifier(value="taskExecutor")
    TaskExecutor taskExecutor;
    @Autowired
    RestUtil restUtil;
    private Set<String> agentIds = new HashSet();
    private static Map<String, AgentExecutor> agentExecutorMap = new ConcurrentHashMap();
    private Thread thread;
    private static ClassLoader dqvClassLoader;

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        this.agentIds = LoadConfigFile.getInstance().getMasterAgentIds();
        if (this.agentIds != null && !this.agentIds.isEmpty()) {
            boolean bl = true;
            for (String string : this.agentIds) {
                AgentExecutor agentExecutor = this.getAgentExecutorBean(string);
                if (!bl) {
                    agentExecutor.markAsInitialized();
                }
                agentExecutorMap.put(string, agentExecutor);
                this.taskExecutor.execute((Runnable)agentExecutor);
                if (bl) {
                    agentExecutor.waitForInitialization();
                    bl = false;
                }
                logger.info("Agent initialization done for agentId : {}", (Object)string);
            }
        } else {
            logger.info("Agent id is not found in properties. So proceeding with agent registration.");
            String string = "agent/v1/agents/0/agentRegistration";
            WindowsBrowserUtil.openBrowserProfile((Browser)Browser.CHROME, (String)string);
        }
    }

    public void stop() {
        if (this.agentIds != null && !this.agentIds.isEmpty()) {
            for (String string : this.agentIds) {
                if (string == null) continue;
                LoadConfigFile.setAgentId((String)string);
                AgentExecutor agentExecutor = MasterAgentExecutor.getAgentExecutor((String)string);
                if (agentExecutor != null) {
                    agentExecutor.stop();
                }
                this.restUtil.postData("terminate/" + string, (Object)"AGENT_SHUTDOWN_INDICATOR", null);
            }
        }
        logger.info("Agent terminated");
    }

    public static void setServerUrlExists(boolean bl) {
        serverUrlExists = bl;
    }

    public static FrameworkQueueDetails getFrameworkQueueDetails(String string) {
        AgentExecutor agentExecutor = (AgentExecutor)agentExecutorMap.get(string);
        return Objects.requireNonNull(agentExecutor.getFrameworkQueueDetail());
    }

    public static Map<Integer, TestRunLogger> getTestRunLoggerMap(String string) {
        AgentExecutor agentExecutor = (AgentExecutor)agentExecutorMap.get(string);
        return agentExecutor.getLoggerMap();
    }

    public static AgentExecutor getAgentExecutor(String string) {
        if (!agentExecutorMap.isEmpty()) {
            return Objects.requireNonNull((AgentExecutor)agentExecutorMap.get(string), "Agent Executor not found for agentId : " + string);
        }
        return null;
    }

    public static boolean isServerUrlExists() {
        return serverUrlExists;
    }

    private AgentExecutor getAgentExecutorBean(String string) {
        try {
            return (AgentExecutor)AutowireHelperUtil.getBeanByConstructorParams((String)"agentExecutor", (Object[])new Object[]{string});
        }
        catch (Exception exception) {
            logger.error("Error while obtaining the Agent Executor bean", (Throwable)exception);
            return null;
        }
    }

    public static AsyncUpdaterThread getAsyncUpdaterThread(String string) {
        AgentExecutor agentExecutor = (AgentExecutor)agentExecutorMap.get(string);
        return Objects.requireNonNull(agentExecutor.getAsyncUpdaterThread());
    }

    public static void waitOnTestRunPause(int n2, String string) {
        AgentExecutor.Executor executor;
        AgentExecutor agentExecutor;
        logger.info("testRunExecutionId : {}, agentId : {}", (Object)n2, (Object)string);
        if (n2 > 0 && string != null && (agentExecutor = MasterAgentExecutor.getAgentExecutor((String)string)) != null && (executor = (AgentExecutor.Executor)agentExecutor.getExecutorMap().get(n2)) != null) {
            executor.waitIfPaused();
        }
    }

    public void pauseAllAgentExecutors(BaseCommand baseCommand) {
        String string = baseCommand.getSenderReferenceId();
        agentExecutorMap.forEach((string2, agentExecutor) -> {
            if (!string.equals(String.valueOf(string2))) {
                agentExecutor.pause();
            }
        });
    }

    public void resumeAllAgentExecutors(BaseCommand baseCommand) {
        String string = baseCommand.getSenderReferenceId();
        agentExecutorMap.forEach((string2, agentExecutor) -> {
            if (!string.equals(String.valueOf(string2))) {
                agentExecutor.resume();
            }
        });
    }

    public static ClassLoader getDqvClassLoader() {
        if (dqvClassLoader == null) {
            if (DQVAction.getDqvClassLoader() != null) {
                dqvClassLoader = DQVAction.getDqvClassLoader();
            } else {
                dqvClassLoader = ClassPathUtil.getDQVClassLoader();
                DQVAction.setDqvClassLoader((ClassLoader)dqvClassLoader);
            }
        }
        return dqvClassLoader;
    }

    static {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

