/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.AgentApplication;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.common.common.AgentCondition;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.messages.MessageUtils;
import com.kumaran.tac.common.servlet.BasicAuthRequestFilter;
import com.kumaran.tac.common.util.AutowireHelperUtil;
import com.kumaran.tac.common.util.CommonUtility;
import com.kumaran.tac.common.util.CompareUtility;
import com.kumaran.tac.common.util.IConfigFile;
import com.kumaran.tac.common.windows.WindowsBrowserUtil;
import com.kumaran.tac.framework.common.util.FrameworkSpringConfiguration;
import com.kumaran.tac.obf.a;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.jasypt.properties.EncryptableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Conditional(value={AgentCondition.class})
public class LoadConfigFile
implements IConfigFile {
    private static final Logger logger = LoggerFactory.getLogger(LoadConfigFile.class);
    private final Properties configDefaultsProp;
    private final Properties configProp;
    private static boolean errorDisplayedOnce = false;
    private static ThreadLocal<String> currentAgentId = new ThreadLocal();
    private static LoadConfigFile INSTANCE = null;
    @Autowired
    RestUtil restUtil;

    LoadConfigFile() {
        Object object;
        Object object2;
        block48: {
            File file;
            block47: {
                Object object3;
                this.configDefaultsProp = new EncryptableProperties(FrameworkSpringConfiguration.stringEncryptor());
                this.configProp = new EncryptableProperties(FrameworkSpringConfiguration.stringEncryptor());
                try {
                    object3 = this.getClass().getClassLoader().getResourceAsStream("tac-agent-defaults.properties");
                    try {
                        if (((InputStream)object3).available() > 0) {
                            this.configDefaultsProp.load((InputStream)object3);
                            this.configProp.putAll((Map<?, ?>)this.configDefaultsProp);
                        }
                    }
                    finally {
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error("Inside LoadConfigFile constructor - can't load tac-agent-defaults.properties file", (Throwable)exception);
                }
                object3 = a.c;
                String string = AgentApplication.getProvidedConfigFile();
                boolean bl = false;
                if (string != null) {
                    logger.warn("Agent properties configuration file is different: {}", (Object)string);
                    object3 = string;
                    bl = true;
                }
                if (!(file = new File((String)object3)).exists()) {
                    try {
                        object2 = LoadConfigFile.class.getClassLoader().getResourceAsStream("init-agent.properties");
                        try {
                            object = new FileOutputStream(file);
                            try {
                                FileCopyUtils.copy((InputStream)object2, (OutputStream)object);
                            }
                            finally {
                                ((FileOutputStream)object).close();
                            }
                        }
                        finally {
                            if (object2 != null) {
                                ((InputStream)object2).close();
                            }
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Error creating agent.properties from the init-agent.properties.", (Throwable)exception);
                    }
                }
                if (bl) {
                    try {
                        object2 = new FileInputStream(a.c);
                        try {
                            if (((InputStream)object2).available() > 0) {
                                this.configProp.load((InputStream)object2);
                            }
                        }
                        finally {
                            ((InputStream)object2).close();
                        }
                    }
                    catch (Exception exception) {
                        if (errorDisplayedOnce) break block47;
                        logger.error("Inside LoadConfigFile constructor - can't load '{}' file", (Object)a.c, (Object)exception);
                    }
                }
            }
            try {
                object2 = new FileInputStream(file);
                try {
                    if (((InputStream)object2).available() > 0) {
                        this.configProp.load((InputStream)object2);
                    }
                }
                finally {
                    ((InputStream)object2).close();
                }
            }
            catch (Exception exception) {
                if (errorDisplayedOnce) break block48;
                logger.error("Inside LoadConfigFile constructor - can't load '{}' file", (Object)file, (Object)exception);
            }
        }
        if ((object2 = this.configProp.getProperty("agent.serverUrl")) != null && ((String)object2).trim().length() == 0) {
            this.configProp.remove("agent.serverUrl");
        }
        if ((object = this.configProp.getProperty("agent.agentId")) == null || object != null && ((String)object).trim().length() == 0) {
            this.configProp.remove("agent.agentId");
        } else {
            System.setProperty("CURRENT_AGENT_ID", (String)object);
            BasicAuthRequestFilter.setAgentId((String)object);
        }
        String string = this.configProp.getProperty("agent.tenantId");
        if (string != null && string.trim().length() == 0) {
            this.configProp.remove("agent.tenantId");
        }
        WindowsBrowserUtil.setConfigFile((IConfigFile)this);
    }

    public static LoadConfigFile getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LoadConfigFile();
        }
        return INSTANCE;
    }

    public static void refresh() {
        INSTANCE = null;
        try {
            ((RestUtil)AutowireHelperUtil.getBeanObj(RestUtil.class)).refresh();
        }
        catch (Exception exception) {
            logger.error("Unable to refresh RestUtil", (Throwable)exception);
        }
    }

    public String getPropertyAsString(String string) {
        return this.getPropertyAsString(string, null);
    }

    public String getPropertyAsString(String string, String string2) {
        return this.configProp.getProperty(string, string2);
    }

    public Integer getPropertyAsIntger(String string) {
        return this.getPropertyAsIntger(string, null);
    }

    public Integer getPropertyAsIntger(String string, Integer n2) {
        String string2 = this.configProp.getProperty(string);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public Boolean getPropertyAsBoolean(String string) {
        return this.getPropertyAsBoolean(string, null);
    }

    public Boolean getPropertyAsBoolean(String string, Boolean bl) {
        String string2 = this.configProp.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        try {
            return Boolean.parseBoolean(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return bl;
        }
    }

    public static void setErrorDisplayedOnce(boolean bl) {
        errorDisplayedOnce = bl;
    }

    public String getServerUrl() {
        return LoadConfigFile.getInstance().getPropertyAsString("agent.serverUrl");
    }

    public Optional<String> getAgentIdFromProperty() {
        Set set;
        Optional<String> optional = Optional.ofNullable(LoadConfigFile.getInstance().getPropertyAsString("agent.agentId"));
        if (!optional.isPresent() && (set = this.getAgentIds()) != null && !set.isEmpty()) {
            optional = set.stream().findFirst();
        }
        return optional;
    }

    public Set<String> getAgentIds() {
        return LoadConfigFile.getInstance().getPropertyAsSetofInteger("agent.agentIds");
    }

    public Set<String> getMasterAgentIds() {
        Set set = this.getAgentIds();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string = LoadConfigFile.getInstance().getPropertyAsString("agent.agentId");
        if (string != null) {
            linkedHashSet.add(string);
        }
        if (set != null && !set.isEmpty()) {
            linkedHashSet.addAll(set);
        }
        return linkedHashSet;
    }

    public Map<Object, Object> getPropertiesAsMap() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (this.configProp != null) {
            hashMap = new HashMap<Object, Object>(this.configProp);
        }
        return hashMap;
    }

    public Map<Object, Object> getDefaultPropertiesAsMap() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (this.configDefaultsProp != null) {
            hashMap = new HashMap<Object, Object>(this.configDefaultsProp);
        }
        return hashMap;
    }

    public static void createPropertyFile(File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
            if (!file.createNewFile()) {
                throw new TACException(MessageUtils.getMessage((String)"FILE_CREATION_FAILED"));
            }
        }
    }

    public static void writePropertyFile(Map<?, ?> map) throws Exception {
        File file = new File(a.c);
        String string = AgentApplication.getProvidedConfigFile();
        if (string != null) {
            logger.warn("Agent properties configuration file is different: {}", (Object)string);
            file = new File(string);
        }
        LoadConfigFile.removeUnchangedDefaultProperties(map);
        for (Map.Entry propertiesConfigurationLayout2 : LoadConfigFile.getInstance().getPropertiesAsMap().entrySet()) {
            if (map.containsKey(propertiesConfigurationLayout2.getKey())) continue;
            map.put(propertiesConfigurationLayout2.getKey(), null);
        }
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        PropertiesConfigurationLayout propertiesConfigurationLayout = propertiesConfiguration.getLayout();
        propertiesConfigurationLayout.load(propertiesConfiguration, (Reader)new FileReader(file));
        logger.info("Properties updated in file are -");
        map.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            if (entry.getValue() != null) {
                logger.info("{} : {}", entry.getKey(), entry.getValue());
                logger.info(" set property{} : {}", entry.getKey(), entry.getValue());
                propertiesConfiguration.setProperty((String)entry.getKey(), entry.getValue());
            } else {
                logger.info("clear property{} : {}", entry.getKey(), entry.getValue());
                propertiesConfiguration.clearProperty((String)entry.getKey());
            }
        });
        propertiesConfigurationLayout.save(propertiesConfiguration, (Writer)new FileWriter(file, false));
    }

    private static void removeUnchangedDefaultProperties(Map<?, ?> map) {
        Map map2 = LoadConfigFile.getInstance().getDefaultPropertiesAsMap();
        ArrayList arrayList = new ArrayList(map.keySet());
        for (Object e2 : arrayList) {
            if (!map2.containsKey(e2)) continue;
            String string = (String)map2.get(e2);
            String string2 = (String)map.get(e2);
            if (!CompareUtility.simpleStringEquals((String)string2, (String)string, (boolean)false)) continue;
            map.remove(e2);
        }
    }

    public Set<String> getPropertyAsSetofInteger(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.configProp.getProperty(string);
        if (!CommonUtility.isEmpty((String)string2)) {
            String[] stringArray;
            for (String string3 : stringArray = string2.trim().split(",")) {
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    public String getExecutingAgentId() {
        return LoadConfigFile.getAgentId();
    }

    public void setExecutingAgentId(String string) {
        LoadConfigFile.setAgentId((String)string);
    }

    public static String getAgentId() {
        return Objects.requireNonNull((String)currentAgentId.get());
    }

    public static void setAgentId(String string) {
        currentAgentId.set(string);
        MDC.put((String)"agentId", (String)(string == null ? "<none>" : string));
    }

    public void checkAndConvertAgentIdToString() {
        block9: {
            try {
                String string = "agent.agentId";
                String string2 = this.configProp.getProperty(string);
                if (string2 != null && !string2.trim().isEmpty()) {
                    currentAgentId.set(string2);
                    try {
                        String string32;
                        Integer.parseInt(string2.trim());
                        logger.info("Found agent.agentId with integer value: {}, converting to string format", (Object)string2);
                        String string4 = " agents/" + string2 + "/getAgentTrid";
                        RestUtil restUtil = this.restUtil;
                        if (restUtil == null) {
                            try {
                                restUtil = (RestUtil)AutowireHelperUtil.getBeanObj(RestUtil.class);
                            }
                            catch (Exception exception) {
                                logger.warn("RestUtil not available yet, skipping agent ID conversion: {}", (Object)exception.getMessage());
                                return;
                            }
                        }
                        String string5 = (String)restUtil.getData(string4, String.class);
                        logger.info("Agenttrid retrieve from server is :{}", (Object)string5);
                        LoadConfigFile.getInstance().configProp.setProperty("agent.agentId", string5);
                        String string6 = string5;
                        currentAgentId.set(string5);
                        LoadConfigFile.getInstance();
                        LoadConfigFile.setAgentId((String)string5);
                        this.configProp.setProperty(string, string6);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        for (String string32 : this.configProp.stringPropertyNames()) {
                            hashMap.put(string32, this.configProp.getProperty(string32));
                        }
                        File file = new File(a.c);
                        string32 = new PropertiesConfiguration();
                        PropertiesConfigurationLayout propertiesConfigurationLayout = string32.getLayout();
                        propertiesConfigurationLayout.load((PropertiesConfiguration)string32, (Reader)new FileReader(file));
                        logger.info("Properties updated in file are -");
                        hashMap.entrySet().stream().filter(Objects::nonNull).forEach(arg_0 -> LoadConfigFile.lambda$checkAndConvertAgentIdToString$1((PropertiesConfiguration)string32, arg_0));
                        propertiesConfigurationLayout.save((PropertiesConfiguration)string32, (Writer)new FileWriter(file, false));
                        logger.info("Successfully converted agent.agentId from '{}' to '{}' and updated properties file", (Object)string2, (Object)string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug("agent.agentId value '{}' is not an integer, no conversion needed", (Object)string2);
                    }
                    break block9;
                }
                logger.debug("agent.agentId property not found or is empty, no conversion needed");
            }
            catch (Exception exception) {
                logger.error("Error checking and converting agent.agentId property", (Throwable)exception);
            }
        }
    }

    @PostConstruct
    public void init() {
        logger.debug("PostConstruct: Checking and converting agent ID...");
        this.checkAndConvertAgentIdToString();
        String string = this.configProp.getProperty("agent.agentId");
        if (string == null || string != null && string.trim().length() == 0) {
            this.configProp.remove("agent.agentId");
        } else {
            System.setProperty("CURRENT_AGENT_ID", string);
            BasicAuthRequestFilter.setAgentId((String)string);
        }
    }

    private static /* synthetic */ void lambda$checkAndConvertAgentIdToString$1(PropertiesConfiguration propertiesConfiguration, Map.Entry entry) {
        logger.info("{} : {}", entry.getKey(), entry.getValue());
        if (entry.getValue() != null) {
            logger.info(" set property{} : {}", entry.getKey(), entry.getValue());
            propertiesConfiguration.setProperty((String)entry.getKey(), entry.getValue());
        } else {
            logger.info("clear property{} : {}", entry.getKey(), entry.getValue());
            propertiesConfiguration.clearProperty((String)entry.getKey());
        }
    }
}

