/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.aspect.annotation.NoAspect;
import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.AgentExecutor;
import com.kumaran.tac.agent.util.CompleteTestRunExecution;
import com.kumaran.tac.agent.util.ExecuteFramework;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.agent.util.ScreenVideoUtil;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.agent.util.TestRunLogger;
import com.kumaran.tac.common.dto.AgentCommand;
import com.kumaran.tac.common.enums.AgentCommandMessage;
import com.kumaran.tac.common.enums.AgentTestRunExecutionPhase;
import com.kumaran.tac.common.enums.TestStepStatus;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.messages.MessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@NoAspect
public class FrameworkQueueDetails {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkQueueDetails.class);
    @Autowired
    private AgentService agentService;
    @Autowired
    RestUtil restUtil;
    private AgentExecutor agentExecutor;
    private CompleteTestRunExecution completeTestRunExecution;

    public FrameworkQueueDetails(AgentExecutor agentExecutor) {
        this.agentExecutor = agentExecutor;
    }

    public CompleteTestRunExecution getCompleteTestRunExecution() {
        return this.completeTestRunExecution;
    }

    public void abortTestRun(boolean bl, String string) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        int n2 = testRunExecutionData.getTestRunExecutionId();
        logger.info("This is NOT AN ERROR. It is a debug message. testRunExecutionId : {}", (Object)n2, (Object)new Exception());
        this.abortAllQueuedProcess();
        if (n2 > 0) {
            if (string == null) {
                string = MessageUtils.getMessage((String)"ABORT_MESSAGE_GENERAL_EXCEPTION");
            }
            try {
                if (bl) {
                    boolean bl2 = true;
                    testRunExecutionData.setAbortFlagTriggeredByAgent(bl2);
                    this.sendAbortMessageToServer(string);
                } else if (ExecuteFramework.getFrameworkStatus((String)this.agentExecutor.getAgentId()).isEmpty()) {
                    this.sendCompletedMessageToServer(Integer.valueOf(n2), TestStepStatus.ABORTED);
                }
            }
            catch (Exception exception) {
                logger.error("Error aborting test run", (Throwable)exception);
            }
        }
    }

    public void abortRun(boolean bl, String string) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        int n2 = testRunExecutionData.getTestRunExecutionId();
        this.abortAllQueuedProcess();
        if (n2 > 0) {
            if (string == null) {
                string = MessageUtils.getMessage((String)"ABORT_MESSAGE_GENERAL_EXCEPTION");
            }
            try {
                if (bl) {
                    boolean bl2 = true;
                    testRunExecutionData.setAbortFlagTriggeredByAgent(bl2);
                    this.sendAbortMessageToServer(string, true);
                } else if (ExecuteFramework.getFrameworkStatus((String)this.agentExecutor.getAgentId()).isEmpty()) {
                    this.sendCompletedMessageToServer(Integer.valueOf(n2), TestStepStatus.ABORTED);
                }
            }
            catch (Exception exception) {
                logger.error("Error aborting test run", (Throwable)exception);
            }
        }
    }

    private void sendAbortMessageToServer(String string) {
        this.sendAbortMessageToServer(string, false);
    }

    private void sendAbortMessageToServer(String string, boolean bl) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        int n2 = testRunExecutionData.getTestRunExecutionId();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("abortMessage", string);
        hashMap.put("testRunExecutionId", n2);
        hashMap.put("frameworkName", "data");
        String string2 = "abortAgent/" + this.agentExecutor.getAgentId();
        logger.info("Abort Request to URL: {}", (Object)string2);
        String string3 = (String)this.restUtil.postData(string2, hashMap, String.class);
        logger.info("Abort Response: {}", (Object)string3);
    }

    public void abortTestRun(boolean bl) {
        this.abortTestRun(bl, null);
    }

    public void abortAllQueuedProcess() {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        int n2 = testRunExecutionData.getTestRunExecutionId();
        AgentCommand agentCommand = new AgentCommand(AgentCommandMessage.TestRunExecution, AgentTestRunExecutionPhase.TestRunAborted, n2);
        this.sendMessageToAllFrameworks(agentCommand, null, this.agentExecutor.getAgentId());
        this.setTestrunRunning(false);
    }

    public void sendMessageToAllFrameworks(AgentCommand agentCommand, List<String> list, String string2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Map map = testRunExecutionData.getFrameworkQueueMap(string2);
        if (map != null) {
            map.forEach((string, blockingQueue) -> {
                try {
                    if (list == null || !list.contains(string)) {
                        blockingQueue.put(agentCommand);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (logger.isDebugEnabled()) {
                        logger.error("InterruptedException exception occurred: ", (Throwable)interruptedException);
                    } else {
                        logger.error("InterruptedException exception occurred:  {}", (Object)interruptedException.getMessage());
                    }
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    private BlockingQueue<AgentCommand> getFrameworkQueue(int n2, String string, String string2, Boolean bl) throws InterruptedException {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        String string3 = this.agentExecutor.getAgentId();
        if (n2 > 0) {
            if (!ExecuteFramework.isFrameworkRunning((String)string, (String)string3)) {
                logger.info("Not exist Create new framework Queue  : {}", (Object)string);
                this.agentService.invokeFramework(Integer.valueOf(n2), string, string2, bl, string3);
            } else if (bl != null) {
                Object object;
                boolean bl2 = testRunExecutionData.isRestartFramework();
                int n3 = ExecuteFramework.getFrameworkTestrunExecutionId((String)string, (String)string3);
                boolean bl3 = testRunExecutionData.isMovedToNewExecution();
                logger.info("Restart Framework : {} and Framework running tre id : {} and current test run execution id : {} and tred movedToNewExecution : {}", new Object[]{bl2, n3, n2, bl3});
                if (!bl2 && n3 != n2 && (object = ExecuteFramework.getCurrentExecuteFramework((String)string, (String)string3)) != null) {
                    logger.info("Existing execute framework found for the framework : {}. Just updating the properties file.", (Object)string);
                    object.updateToNewRun(n2, string, string2, bl);
                }
                if (!bl2 && bl3) {
                    object = testRunExecutionData.getFirstProcess(string, string3);
                    testRunExecutionData.setMovedToNewExecution(false);
                    logger.info("Invoking new ExecuteFramework for framework : {} with process", (Object)string);
                    this.agentService.invokeFramework(Integer.valueOf(n2), string, string2, bl, (Process)object, string3);
                }
                if (bl2) {
                    logger.info("Triggering shutdown flag for framework : {}", (Object)string);
                    testRunExecutionData.setRestartFramework(false);
                    this.shutdownFramework(string, bl, n2, true);
                    this.agentService.invokeFramework(Integer.valueOf(n2), string, string2, bl, string3);
                } else {
                    ExecuteFramework.setFrameworkDebugMode((String)string, (Boolean)bl, (Integer)n2, (String)string3);
                    logger.info("Updating the framework : {} debugMode : {} for currentTre Id : {}", new Object[]{string, bl, n2});
                }
            } else {
                logger.info("ExecuteFramework already exist for framework : {} and debugmode is null", (Object)string);
            }
        } else {
            logger.info("Skipping framework creation process for the temp queue #0.");
        }
        return this.getFrameworkQueueOnly(string, string3);
    }

    public void sendShutdownFrameworkMessage(String string, Boolean bl) {
        AgentCommand agentCommand = new AgentCommand(AgentCommandMessage.FrameworkShutdown);
        try {
            this.getFrameworkQueueOnly(string, this.agentExecutor.getAgentId()).put(agentCommand);
            logger.info("Shut down framework message sent to framework : {} through temp queue id#{}", (Object)string, (Object)TestRunExecutionData.getCurrentTestRunExecutionId());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void shutdownFramework(String string, Boolean bl, int n2, boolean bl2) {
        String string2 = this.agentExecutor.getAgentId();
        new /* Unavailable Anonymous Inner Class!! */.start();
        if (bl2) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            logger.info("Wait For set to false so agent not waiting for framework to complete");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.completeTestRunExecution = new CompleteTestRunExecution(this, Integer.valueOf(n2), LoadConfigFile.getAgentId());
        this.completeTestRunExecution.setShutDownFramework(countDownLatch, string);
        this.completeTestRunExecution.start();
        if (bl2) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void shutdownAllDebuggingFrameworkForCurrentExecution() {
        Object object;
        Object object2;
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        int n2 = testRunExecutionData.getTestRunExecutionId();
        String string = this.agentExecutor.getAgentId();
        Map map = ExecuteFramework.getAllDebugModeCompletedId((String)string);
        if (map != null) {
            object2 = map.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(n2)).map(Map.Entry::getKey).collect(Collectors.toList());
            object = object2.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                this.shutdownFramework(string2, Boolean.valueOf(true), n2, false);
                ExecuteFramework.removeDebugModeCompletedId((String)string2, (int)n2, (String)string);
            }
        }
        object2 = String.format("agents/%s/tre/%d/acknowledgeAllFrameworkShutdown", string, n2);
        object = (String)this.restUtil.getData((String)object2, String.class);
        logger.info("Ack framework shutdown sent. Response : {}", object);
    }

    public void shutdownAllDebuggingFramework(boolean bl) {
        String string = this.agentExecutor.getAgentId();
        Map map = ExecuteFramework.getAllDebugModeCompletedId((String)string);
        if (map != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry entry : map.entrySet()) {
                for (Integer n2 : (List)entry.getValue()) {
                    if (!arrayList.contains(entry.getKey())) {
                        logger.info("clearing completed frameworks ,agentId : {}", (Object)string);
                        TestRunExecutionData.getTestRunExecutionData((int)n2).getCompletedFrameworks(string).clear();
                        logger.info("after clearing Queue : {},agentId : {}", (Object)TestRunExecutionData.getTestRunExecutionData((int)n2).getcompletedQueue(), (Object)string);
                        this.shutdownFramework((String)entry.getKey(), Boolean.valueOf(true), n2.intValue(), bl);
                        arrayList.add((String)entry.getKey());
                        continue;
                    }
                    logger.info("Shutdown trigger already sent to framework : {}", entry.getKey());
                }
                ExecuteFramework.removeDebugModeCompletedFramework((String)((String)entry.getKey()), (String)string);
            }
        }
    }

    private BlockingQueue<AgentCommand> getFrameworkQueueOnly(String string2, String string3) throws InterruptedException {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Map map = testRunExecutionData.getFrameworkQueueMap(string3);
        logger.info("Framework : {} Queue data : {}", (Object)string2, (Object)map);
        map.computeIfAbsent(string2, string -> new LinkedBlockingQueue());
        return (BlockingQueue)map.get(string2);
    }

    public synchronized void sendToFrameworkQueue(int n2, String string, String string2, Boolean bl, AgentCommand agentCommand) throws InterruptedException {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        boolean bl2 = testRunExecutionData.isAbortFlagTriggeredByAgent();
        if (!bl2) {
            this.getFrameworkQueue(n2, string, string2, bl).put(agentCommand);
            logger.info("Added data : {} into {} queue", (Object)agentCommand, (Object)string);
        } else {
            logger.info("Data cannot be added to {} framework queue as Abort flag initiated by agent.", (Object)string);
        }
    }

    public AgentCommand getPendingDataToFramework(String string, String string2) throws InterruptedException {
        return (AgentCommand)this.getFrameworkQueueOnly(string, string2).poll(30L, TimeUnit.SECONDS);
    }

    public Map<String, BlockingQueue<AgentCommand>> getFrameworkQueueMap(String string) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return testRunExecutionData.getFrameworkQueueMap(string);
    }

    public void setFrameworkQueueMap(Map<String, Map<String, BlockingQueue<AgentCommand>>> map) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        testRunExecutionData.setFrameworkQueueMap(map);
    }

    public boolean isAnyTestrunRunning() {
        return TestRunExecutionData.isAnyTestrunRunning();
    }

    public boolean isCurrentTestRunning() {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        if (testRunExecutionData == null) {
            throw new TACException(String.format("Test-run execution data cannot be null. TestRunExecutionId : %d ", TestRunExecutionData.getCurrentTestRunExecutionId()));
        }
        return testRunExecutionData.isTestrunRunning();
    }

    public boolean isAnyTestRunCleanupRunning() {
        return TestRunExecutionData.isAnyTestRunCleanupRunning();
    }

    public void setTestrunRunning(boolean bl) {
        String string = this.agentExecutor.getAgentId();
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        int n2 = testRunExecutionData.getTestRunExecutionId();
        if (!bl && this.completeTestRunExecution != null && !this.completeTestRunExecution.isInitialized()) {
            testRunExecutionData.setTestRunCleanupRunning(true);
        }
        testRunExecutionData.setTestrunRunning(bl);
        if (bl) {
            testRunExecutionData.setAbortFlagTriggeredByAgent(false);
            logger.info("clearing completed frameworks ,agentId : {}", (Object)string);
            testRunExecutionData.getFrameworkQueueMap(string).clear();
            testRunExecutionData.getCompletedFrameworks(string).clear();
            logger.info("after clearing Queue : {},agentId : {}", (Object)testRunExecutionData.getcompletedQueue(), (Object)string);
        }
        if (!bl && this.completeTestRunExecution == null) {
            logger.info("Complete test run execution triggered for agentId : {}", (Object)string);
            this.completeTestRunExecution = new CompleteTestRunExecution(this, Integer.valueOf(n2), string);
            this.completeTestRunExecution.start();
        }
    }

    public void setTestRunExecutionId(int n2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        testRunExecutionData.setTestRunExecutionId(n2);
    }

    public void sendCompletedMessageToServer(Integer n2, TestStepStatus testStepStatus) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData((int)n2);
        String string = this.agentExecutor.getAgentId();
        ScreenVideoUtil.closeAllRunningAsCompleted((TestStepStatus)testStepStatus);
        String string2 = "agentCompleted/" + string;
        String string3 = (String)this.restUtil.getData(string2, String.class);
        logger.info("Agent completed the test run with respone : {}", (Object)string3);
        logger.info("Stopping logging for TestRunExecution : {}", (Object)n2);
        logger.info("Clearing completed framework queue for agentId : {}", (Object)string);
        testRunExecutionData.getCompletedFrameworks(string).clear();
        logger.info("after clearing queue : {}", (Object)testRunExecutionData.getcompletedQueue());
        if (testRunExecutionData.isValidToClear(string)) {
            testRunExecutionData.getFrameworkQueueMap(string).clear();
            this.agentService.terminateAllDownloadMonitors();
            logger.info("Framework queue and completed queue were cleared.");
            TestRunExecutionData.clear();
        } else {
            logger.info("Test Run execution data for id : {} are retained.", (Object)n2);
        }
        if (n2 != null) {
            TestRunLogger testRunLogger = TestRunLogger.getTestRunLogger((Integer)n2, (String)string);
            this.agentService.resetUploadFileInstance(n2.intValue(), testRunLogger);
            testRunLogger.stop();
        }
        try {
            this.agentExecutor.addMessageToServerCallQueue("Completed.", string);
            logger.info("TestRunExecution Id {} is completed, So triggering agent to get next data from server.", (Object)n2);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public BlockingQueue<String> getCompletedFrameworks() {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return testRunExecutionData.getCompletedFrameworks(this.agentExecutor.getAgentId());
    }

    public void addCompletedFramework(String string) {
        String string2 = this.agentExecutor.getAgentId();
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        BlockingQueue blockingQueue = testRunExecutionData.getCompletedFrameworks(string2);
        try {
            blockingQueue.put(string);
            logger.info("Added {} framework into CompletedQueue {}", (Object)string, (Object)blockingQueue);
        }
        catch (Exception exception) {
            logger.error("Error occurred ", (Throwable)exception);
        }
        logger.info("Completed framework queue : {}, agentId : {}", (Object)testRunExecutionData.getCompletedFrameworks(string2), (Object)string2);
    }

    public void startOrStopDebug(AgentCommand agentCommand) {
        String string = this.agentExecutor.getAgentId();
        Boolean bl = null;
        if (agentCommand.getMsg() == AgentCommandMessage.StartDebug) {
            bl = true;
        } else if (agentCommand.getMsg() == AgentCommandMessage.StopDebug) {
            bl = false;
        } else {
            return;
        }
        TestRunExecutionData.getTestRunExecutionData().setDebugMode(bl);
        Map map = TestRunExecutionData.getTestRunExecutionData().getFrameworkStatus(string);
        try {
            for (String string2 : map.keySet()) {
                this.getFrameworkQueueOnly(string2, string).put(agentCommand);
                if (!bl.booleanValue()) {
                    ExecuteFramework.removeDebugModeCompletedId((String)string2, (int)TestRunExecutionData.getCurrentTestRunExecutionId(), (String)string);
                    continue;
                }
                logger.info("Debug mode is true so retaining the framework entry in the map. {}", (Object)ExecuteFramework.getAllDebugModeCompletedId((String)string));
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void startNewDebugSessionIfRequired(AgentCommand agentCommand) {
        Map map;
        boolean bl = false;
        if (agentCommand != null && (map = agentCommand.getData()) != null && map.containsKey("startNewDebugSession")) {
            bl = map.getOrDefault("startNewDebugSession", false);
            if (bl) {
                logger.info("Start new debug session found. Shutdowning all debugging frameworks");
                this.shutdownAllDebuggingFramework(true);
            }
            logger.info("Setting null to the test data of agentcommand : {}", (Object)agentCommand);
            agentCommand.setData(null);
        }
        if (!bl) {
            logger.info("Start new debug session not provided. Hence continuing in current debugging framework. {}", (Object)ExecuteFramework.getAllDebugModeCompletedId((String)this.agentExecutor.getAgentId()));
        }
    }

    public void clear() {
        this.completeTestRunExecution = null;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

