/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.AgentApplication;
import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.FrameworkQueueDetails;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.agent.util.TestRunLogger;
import com.kumaran.tac.common.dto.AgentCommand;
import com.kumaran.tac.common.enums.AdhocIndicator;
import com.kumaran.tac.common.enums.AgentCommandMessage;
import com.kumaran.tac.common.enums.Browser;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.messages.MessageUtils;
import com.kumaran.tac.common.util.AutowireHelperUtil;
import com.kumaran.tac.common.util.CommonUtility;
import com.kumaran.tac.common.util.LoggerUtil;
import com.kumaran.tac.common.windows.WindowsBrowserUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecuteFramework
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteFramework.class);
    public static final String STATUS_STARTING = "STARTING";
    public static final String STATUS_COMPLETED = "COMPLETED";
    public static final String STATUS_FAILED = "FAILED";
    public static final String STATUS_WAIT_ON_DEBUG = "WAIT_ON_DEBUG";
    private static final Map<String, Map<String, List<Integer>>> debugModeCompletedIds = new HashMap();
    private String frameworkName;
    private String browserName;
    private List<String> commandlineArgs;
    private File logFolder;
    private File downloadsFolder;
    private File errFile;
    private File outFile;
    private File logFile;
    private File startupDirectory;
    private boolean error = false;
    private FrameworkQueueDetails frameworkQueueDetail;
    private int currentTestRunExecutionId;
    private int firstTestRunExecutionId;
    private boolean isDebugMode;
    private Process previousProcess = null;
    private String agentId;

    public ExecuteFramework(int n2, FrameworkQueueDetails frameworkQueueDetails, String string, File file, List<String> list, Boolean bl, String string2) {
        new ExecuteFramework(n2, frameworkQueueDetails, string, null, file, list, bl, string2);
    }

    public ExecuteFramework(int n2, FrameworkQueueDetails frameworkQueueDetails, String string, String string2, File file, List<String> list, Boolean bl, String string3) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData((int)n2);
        this.frameworkName = string;
        this.isDebugMode = bl == null ? false : bl;
        this.agentId = string3;
        this.setFrameworkStatus("STARTING");
        testRunExecutionData.getExecuteFrameworkMap(string3).put(string, this);
        this.firstTestRunExecutionId = n2;
        this.frameworkQueueDetail = frameworkQueueDetails;
        this.updateToNewRun(n2, string, string2, bl);
        this.startupDirectory = file;
        if (this.startupDirectory == null) {
            this.startupDirectory = new File(".");
        }
        this.commandlineArgs = list;
        ExecuteFramework.setFrameworkDebugMode((String)string, (Boolean)bl, (Integer)n2, (String)string3);
    }

    public static ExecuteFramework getCurrentExecuteFramework(String string, String string2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return (ExecuteFramework)testRunExecutionData.getExecuteFrameworkMap(string2).get(string);
    }

    public void setPreviousProcess(Process process) {
        this.previousProcess = process;
    }

    public void updateToNewRun(int n2, String string, String string2, Boolean bl) {
        int n3 = this.currentTestRunExecutionId;
        boolean bl2 = n3 > 0 && n2 != n3 || "WAIT_ON_DEBUG".equals(ExecuteFramework.getFrameworkStatus((String)string, (String)this.agentId));
        logger.info("Updating to new Run for framework {}. Old={}, New={}, FrameworkStatus={}, Changed={}", new Object[]{string, n3, n2, ExecuteFramework.getFrameworkStatus((String)string, (String)this.agentId), bl2});
        this.currentTestRunExecutionId = n2;
        this.frameworkName = string;
        this.browserName = string2;
        String string3 = n2 + "_" + this.frameworkName + "_" + CommonUtility.fetchDateAndTimeByPattern((String)"MMddHHmmss");
        this.logFolder = TestRunLogger.getTestRunLogger((Integer)n2, (String)this.agentId).getLogFolder();
        this.downloadsFolder = TestRunLogger.getTestRunLogger((Integer)n2, (String)this.agentId).getDownloadsFolder();
        this.logFile = new File(this.logFolder, string3 + ".log.txt");
        if (bl2) {
            this.writeReadMeFile(this.logFolder, Integer.valueOf(n2), Integer.valueOf(n3));
        } else {
            this.outFile = new File(this.logFolder, string3 + ".stdout.txt");
            this.errFile = new File(this.logFolder, string3 + ".stderr.txt");
        }
        ExecuteFramework.setFrameworkDebugMode((String)string, (Boolean)bl, (Integer)n2, (String)this.agentId);
        if (bl2) {
            logger.info("Updating the test run properties from old tre id : {} to new tre id : {}", (Object)n3, (Object)n2);
            this.updateTestRunProperties(null);
        } else {
            logger.info("No updation required on test run properties for old tre id : {} and new tre id : {}", (Object)n3, (Object)n2);
        }
    }

    private void writeReadMeFile(File file, Integer n2, Integer n3) {
        logger.info("Creating README.txt file for Old TestRunExecutionId={}, New TestRunExecutionId={}", (Object)n3, (Object)n2);
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "README.txt"));){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("In debug mode, when the test run execution ID is different, attempts will be made to switch to the new log files.\r\n").append("\r\n").append("However, in some cases, the files could not be swapped. If you find the logs are blank, please refer to the \r\n").append("log files of previous Test Run Execution Id.\r\n").append("Current Test Run Execution Id = ").append(n2).append("\r\n").append("Previous Test Run Execution Id = ").append(n3).append("\r\n").append("First Test Run Execution Id = ").append(this.firstTestRunExecutionId).append("\r\n").append("\r\n").append("Since the framework process is already running, the STDOUT and STDERR files could not be switched.\r\n").append("For these files, please always refer to Previous Test Run Execution Id; more preciously, the test run that \r\n").append("was first executed in debug mode.\r\n");
            fileOutputStream.write(stringBuilder.toString().getBytes());
        }
        catch (IOException iOException) {
            logger.warn("Can't create README.txt file for Old TestRunExecutionId={}, New TestRunExecutionId={}", (Object)n3, (Object)n2);
        }
    }

    public boolean hasError() {
        return this.error;
    }

    public static Boolean getFrameworkDebugMode(String string, String string2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Boolean bl = (Boolean)testRunExecutionData.getFrameworkDebugModeMap(string2).get(string);
        bl = bl == null ? Boolean.FALSE : bl;
        logger.info("Is framework : {} running in debugMode? {}", (Object)string, (Object)bl);
        return bl;
    }

    public static int getFrameworkTestrunExecutionId(String string, String string2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        int n2 = testRunExecutionData.getFrameworkTestRunExecIdMap(string2).getOrDefault(string, 0);
        logger.info("Framework : {} is running under treId : {}", (Object)string, (Object)n2);
        return n2;
    }

    public static void setFrameworkDebugMode(String string, Boolean bl, Integer n2, String string2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Map map = testRunExecutionData.getFrameworkDebugModeMap(string2);
        Map map2 = testRunExecutionData.getFrameworkTestRunExecIdMap(string2);
        if (bl != null) {
            map.put(string, bl);
            logger.info("Adding debugmode : {} against the framework : {}.FrameworkDebugModeMap : {}", new Object[]{bl, string, map});
        } else {
            logger.info("Debug mode is null. So not adding against framework : {}. FrameworkDebugModeMap : {}", (Object)string, (Object)map);
        }
        map2.put(string, n2 == null ? 0 : n2);
        logger.info("Adding TRE Id : {} into framework : {}. frameworkTestRunExecIdMap : {}", new Object[]{n2, string, map2});
    }

    public static boolean isFrameworkRunning(String string, String string2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Map map = testRunExecutionData.getFrameworkStatus(string2);
        String string3 = (String)map.get(string);
        logger.info("{} framework status is {}. FrameworkStatus : {}", new Object[]{string, string3, map});
        return "STARTING".equals(string3) || "WAIT_ON_DEBUG".equals(string3);
    }

    public static Map<String, String> getFrameworkStatus(String string) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Map map = testRunExecutionData.getFrameworkStatus(string);
        logger.info("Framework status of test run execution : {} is {}", (Object)TestRunExecutionData.getCurrentTestRunExecutionId(), (Object)map);
        return map;
    }

    public static String getFrameworkStatus(String string, String string2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Map map = testRunExecutionData.getFrameworkStatus(string2);
        String string3 = (String)map.get(string);
        logger.debug("Status of framework : {} is {}. Framework status : {}", new Object[]{string, string3, map});
        return string3;
    }

    public void setFrameworkStatus(String string) {
        ExecuteFramework.setFrameworkStatus((String)this.frameworkName, (String)string, (String)this.agentId);
    }

    public static void setFrameworkStatus(String string, String string2, String string3) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Map map = testRunExecutionData.getFrameworkStatus(string3);
        map.put(string, string2);
        logger.info("Marking {} framework status as {}. Framework status : {}", new Object[]{string, string2, map});
    }

    void updateTestRunProperties(ProcessBuilder processBuilder) {
        Object object;
        Object object22;
        File file = new File(this.startupDirectory, TestRunExecutionData.getCurrentTestRunExecutionId() + "-" + "testrun.properties");
        logger.info(">> TRPF : {}", (Object)file);
        File file2 = new File(this.startupDirectory, TestRunExecutionData.getCurrentTestRunExecutionId() + "-" + "agent-info.properties");
        Browser browser = Browser.getBrowser((String)this.browserName);
        if (processBuilder == null) {
            WindowsBrowserUtil.setDownloadLocation((Browser)browser, (File)this.downloadsFolder, (String)this.frameworkName);
        }
        HashMap hashMap = new HashMap();
        File file3 = WindowsBrowserUtil.getDownloadLocation((Browser)browser, hashMap);
        logger.info("Updating testrun.properties file. Browser {}, download location={}, other browser options={}", new Object[]{browser, file3, hashMap});
        String string = this.logFile.getParentFile().getAbsolutePath();
        String string2 = this.logFile.getParent().replace('/', File.pathSeparatorChar);
        String string3 = this.logFile.getName();
        String string4 = this.downloadsFolder.getAbsolutePath();
        String string5 = this.downloadsFolder.getAbsolutePath().replace('/', File.pathSeparatorChar);
        if (processBuilder != null) {
            processBuilder.environment().put("TAC_FW_LOG_FOLDER", string);
            processBuilder.environment().put("TAC_FW_LOG_FOLDER_NATIVE", string2);
            processBuilder.environment().put("TAC_FW_LOG_FILE_NAME", string3);
            processBuilder.environment().put("TAC_LOG_LEVEL", this.isDebugMode ? "TRACE" : "INFO");
            processBuilder.environment().put("TAC_DEV_MODE", String.valueOf(AgentApplication.isDevMode()));
        }
        List list = this.getListofProjectUsedInExecution(this.currentTestRunExecutionId, this.frameworkName);
        Properties properties = new Properties();
        properties.setProperty("testRunExecutionId", "" + this.currentTestRunExecutionId);
        properties.setProperty("log.folder", string);
        properties.setProperty("log.folder.native", string2);
        properties.setProperty("log.file", string3);
        properties.setProperty("downloads.folder", string4);
        properties.setProperty("downloads.folder.native", string5);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object22 = (Map)list.get(i2);
            for (Map.Entry entry : object22.entrySet()) {
                String string6 = entry.getValue().toString();
                properties.setProperty((String)entry.getKey(), string6);
            }
        }
        if (file3 != null) {
            String string7 = file3.getAbsolutePath();
            object22 = file3.getAbsolutePath().replace('/', File.pathSeparatorChar);
            properties.setProperty("browser.downloads.folder", string7);
            properties.setProperty("browser.downloads.folder.native", (String)object22);
        }
        for (Object object22 : hashMap.keySet()) {
            Iterator iterator = hashMap.get(object22);
            if (iterator == null) continue;
            properties.setProperty("browser." + (String)object22, iterator.toString());
        }
        try {
            object = new FileOutputStream(file2);
            try {
                object22 = new Properties();
                ((Properties)object22).put("agentUrlForFrameworks", LoadConfigFile.getInstance().getPropertyAsString("agentUrlForFrameworks"));
                ((Properties)object22).store((OutputStream)object, "agent-info.properties");
            }
            finally {
                ((FileOutputStream)object).close();
            }
        }
        catch (IOException iOException) {
            logger.error("Can't store the {} file.", (Object)"agent-info.properties", (Object)iOException);
        }
        try {
            object = new FileOutputStream(file);
            try {
                properties.store((OutputStream)object, string3);
            }
            finally {
                ((FileOutputStream)object).close();
            }
        }
        catch (IOException iOException) {
            logger.error("Can't store the {} file.", (Object)"testrun.properties", (Object)iOException);
        }
        this.copyFile(file, "testrun.properties");
        this.copyFile(file2, "agent-info.properties");
    }

    private void copyFile(File file, String string) {
        try {
            FileUtils.copyFile((File)file, (File)new File(this.startupDirectory, string));
        }
        catch (IOException iOException) {
            logger.error("Can't store the {} file.", (Object)string, (Object)iOException);
        }
    }

    @Override
    public void run() {
        int n2;
        Object object;
        Object object2;
        TestRunExecutionData testRunExecutionData;
        Browser browser;
        File file;
        boolean bl;
        int n3;
        block27: {
            TestRunExecutionData.setCurrentTestRunExecutionId((int)this.currentTestRunExecutionId);
            LoadConfigFile.setAgentId((String)this.agentId);
            n3 = 0;
            bl = false;
            file = null;
            browser = Browser.getBrowser((String)this.browserName);
            try {
                block26: {
                    Object object3;
                    testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
                    logger.warn("Running the framework {}", (Object)this.frameworkName);
                    logger.info("Command line Parameters = {}", (Object)this.commandlineArgs);
                    logger.info("Out File = {}", (Object)this.outFile.getAbsolutePath());
                    logger.info("Error File = {}", (Object)this.errFile.getAbsolutePath());
                    file = WindowsBrowserUtil.setDownloadLocation((Browser)browser, (File)this.downloadsFolder, (String)this.frameworkName);
                    if (file != null && file.toPath().startsWith(new File(CommonUtility.getBaseDir()).toPath())) {
                        file = WindowsBrowserUtil.getUserDownloadsFolder();
                    }
                    object2 = new ArrayList<String>();
                    object2.addAll(this.commandlineArgs);
                    object = null;
                    if (this.previousProcess == null) {
                        logger.info("There is no process already available for framework : {}. Creating new one.", (Object)this.frameworkName);
                        object3 = new ProcessBuilder((List<String>)object2).directory(this.startupDirectory);
                        this.updateTestRunProperties((ProcessBuilder)object3);
                        object = ((ProcessBuilder)object3).start();
                        testRunExecutionData.addProcessForFramework(this.frameworkName, (Process)object, this.agentId);
                    } else {
                        logger.info("There is a process already available for the framework : {}", (Object)this.frameworkName);
                        this.updateTestRunProperties(null);
                        object = this.previousProcess;
                        new /* Unavailable Anonymous Inner Class!! */.start();
                    }
                    object3 = () -> MDC.put((String)"agentId", (String)(this.agentId == null ? "<none>" : this.agentId.toString()));
                    LoggerUtil.inheritIO((String)(this.frameworkName + ".STDOUT"), (boolean)false, (InputStream)((Process)object).getInputStream(), (File)this.outFile, (Runnable)object3);
                    LoggerUtil.inheritIO((String)(this.frameworkName + ".STDERR"), (boolean)true, (InputStream)((Process)object).getErrorStream(), (File)this.errFile, (Runnable)object3);
                    do {
                        boolean bl2;
                        if (!(bl2 = ((Process)object).waitFor(1L, TimeUnit.SECONDS))) continue;
                        logger.info("Framework : {} process completed.", (Object)this.frameworkName);
                        testRunExecutionData.removeProcessForFramework(this.frameworkName, this.agentId);
                        break block26;
                    } while (!"WAIT_ON_DEBUG".equals(ExecuteFramework.getFrameworkStatus((String)this.frameworkName, (String)this.agentId)));
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    hashMap.put("oldId", this.currentTestRunExecutionId);
                    hashMap.put("newId", 0);
                    ExecuteFramework.putDebugModeCompletedId((String)this.frameworkName, (int)this.currentTestRunExecutionId, (String)this.agentId);
                    AgentCommand agentCommand = new AgentCommand(AgentCommandMessage.SwitchTo, hashMap);
                    this.updateToNewRun(0, this.frameworkName, this.browserName, Boolean.valueOf(this.isDebugMode));
                    ConcurrentHashMap concurrentHashMap = TestRunExecutionData.getTestRunExecutionData((int)0).getFrameworkQueueMap(this.agentId);
                    if (concurrentHashMap != null) {
                        BlockingQueue blockingQueue = (BlockingQueue)concurrentHashMap.get(this.frameworkName);
                        logger.info("Old data in the Temp Queue tre#0 : {}", (Object)blockingQueue);
                    } else {
                        concurrentHashMap = new ConcurrentHashMap();
                    }
                    concurrentHashMap.put(this.frameworkName, new LinkedBlockingQueue());
                    this.frameworkQueueDetail.sendToFrameworkQueue(this.currentTestRunExecutionId, this.frameworkName, this.browserName, Boolean.valueOf(this.isDebugMode), agentCommand);
                    logger.info("Framwork : {} is waiting on debug. So process still alive.", (Object)this.frameworkName);
                }
                if (!"WAIT_ON_DEBUG".equals(ExecuteFramework.getFrameworkStatus((String)this.frameworkName, (String)this.agentId))) {
                    n3 = ((Process)object).exitValue();
                    this.setFrameworkStatus("COMPLETED");
                    logger.warn("Framework {} execution is COMPLETED with exit code {}", (Object)this.frameworkName, (Object)n3);
                    break block27;
                }
                logger.info("Framework : {} is waiting on debug. So not checking the exitvalue", (Object)this.frameworkName);
            }
            catch (Exception exception) {
                try {
                    this.error = true;
                    this.setFrameworkStatus("FAILED");
                    logger.error("Framework {} execution is FAILED", (Object)this.frameworkName);
                    logger.error("Error running framework", (Throwable)exception);
                    String string = "ABORT_MESSAGE_GENERAL_EXCEPTION";
                    if (exception instanceof IllegalStateException) {
                        string = n3 == 100 ? "ABORT_MESSAGE_FW_BUSY" : "ABORT_MESSAGE_FW_LAUNCH_ERROR";
                    }
                    this.frameworkQueueDetail.abortTestRun(true, MessageUtils.getMessage((String)string));
                    bl = true;
                    throw new TACException((Throwable)exception);
                }
                catch (Throwable throwable) {
                    int n4;
                    this.frameworkQueueDetail.addCompletedFramework(this.frameworkName);
                    TestRunExecutionData testRunExecutionData2 = TestRunExecutionData.getTestRunExecutionData();
                    String string = ExecuteFramework.getFrameworkStatus((String)this.frameworkName, (String)this.agentId);
                    Map map = testRunExecutionData2.getExecuteFrameworkMap(this.agentId);
                    if (!"WAIT_ON_DEBUG".equals(string)) {
                        map.remove(this.frameworkName);
                        logger.info("Framework : {} status is {}. Removing the instance from the executeFrameworkMap. Map : {}", new Object[]{this.frameworkName, string, map});
                    } else {
                        logger.info("Framework : {} is waiting on debug. So executeFramework instance not removed from map. ExecuteFrameworkMap : {}", (Object)this.frameworkName, (Object)map);
                    }
                    if (this.frameworkQueueDetail.isCurrentTestRunning() && this.frameworkQueueDetail.getCompleteTestRunExecution() == null) {
                        logger.info("Aborting the test run as the Framework {} exited before test run get completed / aborted. Exit code = {}", (Object)this.frameworkName, (Object)n3);
                        this.frameworkQueueDetail.setTestrunRunning(false);
                        if (!bl) {
                            this.frameworkQueueDetail.abortTestRun(true, MessageUtils.getMessage((String)"ABORT_MESSAGE_FRAMEWORK_GENERAL_EXCEPTION"));
                        }
                    }
                    int n5 = n4 = testRunExecutionData2.getAdhocType() != null ? testRunExecutionData2.getAdhocType().getIndicator() : -1;
                    if (!"WAIT_ON_DEBUG".equals(string) || n4 == AdhocIndicator.TESTDATA.getIndicator()) {
                        this.cleanUpProperties();
                        if (file != null) {
                            WindowsBrowserUtil.setDownloadLocation((Browser)browser, (File)file, null);
                        }
                        logger.info("Framework : {} status is {}. So deleting the properties files.", (Object)this.frameworkName, (Object)string);
                    } else {
                        logger.info("Framework : {} is waiting on debug mode. So not deleting properties files.", (Object)this.frameworkName);
                    }
                    throw throwable;
                }
            }
        }
        this.frameworkQueueDetail.addCompletedFramework(this.frameworkName);
        testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        object2 = ExecuteFramework.getFrameworkStatus((String)this.frameworkName, (String)this.agentId);
        object = testRunExecutionData.getExecuteFrameworkMap(this.agentId);
        if (!"WAIT_ON_DEBUG".equals(object2)) {
            object.remove(this.frameworkName);
            logger.info("Framework : {} status is {}. Removing the instance from the executeFrameworkMap. Map : {}", new Object[]{this.frameworkName, object2, object});
        } else {
            logger.info("Framework : {} is waiting on debug. So executeFramework instance not removed from map. ExecuteFrameworkMap : {}", (Object)this.frameworkName, object);
        }
        if (this.frameworkQueueDetail.isCurrentTestRunning() && this.frameworkQueueDetail.getCompleteTestRunExecution() == null) {
            logger.info("Aborting the test run as the Framework {} exited before test run get completed / aborted. Exit code = {}", (Object)this.frameworkName, (Object)n3);
            this.frameworkQueueDetail.setTestrunRunning(false);
            if (!bl) {
                this.frameworkQueueDetail.abortTestRun(true, MessageUtils.getMessage((String)"ABORT_MESSAGE_FRAMEWORK_GENERAL_EXCEPTION"));
            }
        }
        int n6 = n2 = testRunExecutionData.getAdhocType() != null ? testRunExecutionData.getAdhocType().getIndicator() : -1;
        if (!"WAIT_ON_DEBUG".equals(object2) || n2 == AdhocIndicator.TESTDATA.getIndicator()) {
            this.cleanUpProperties();
            if (file != null) {
                WindowsBrowserUtil.setDownloadLocation((Browser)browser, (File)file, null);
            }
            logger.info("Framework : {} status is {}. So deleting the properties files.", (Object)this.frameworkName, object2);
        } else {
            logger.info("Framework : {} is waiting on debug mode. So not deleting properties files.", (Object)this.frameworkName);
        }
    }

    public List<Map<String, Object>> getListofProjectUsedInExecution(int n2, String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try {
            AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
            TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
            List list = agentService.getListOfProjectIds(Integer.valueOf(n2));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                File file = new File(System.getProperty("user.dir"), "CustomFiles" + File.separator + list.get(i2) + File.separator + string);
                File file2 = new File(file, "project.properties");
                if (file.exists()) {
                    if (!file2.exists()) continue;
                    try (FileInputStream fileInputStream = new FileInputStream(file2);){
                        Properties properties = new Properties();
                        properties.load(fileInputStream);
                        String string2 = properties.getProperty("fileName");
                        Object object = properties.get("projectCode");
                        String string3 = "sync.timeout." + object;
                        String string4 = "tac.util.script." + object;
                        String string5 = "web.framework.angular." + object;
                        String string6 = "web.framework.pega." + object;
                        String string7 = "web.framework.jquery." + object;
                        String string8 = "web.framework.other." + object;
                        String string9 = "web.framework.none." + object;
                        hashMap.put(string3, properties.get("timeout"));
                        if (string2 != null && properties.get("web.framework.other").equals("true")) {
                            hashMap.put(string4, new File(file, string2).getAbsolutePath());
                        }
                        hashMap.put(string5, properties.get("web.framework.angular"));
                        hashMap.put(string7, properties.get("web.framework.jquery"));
                        hashMap.put(string6, properties.get("web.framework.pega"));
                        hashMap.put(string8, properties.get("web.framework.other"));
                        hashMap.put(string9, properties.get("web.framework.none"));
                        arrayList.add(hashMap);
                        continue;
                    }
                }
                hashMap.put("sync.timeout", 30);
            }
        }
        catch (Exception exception) {
            logger.info("Error caused due to:", (Throwable)exception);
        }
        return arrayList;
    }

    private File getExecutionPropertiesFile(String string, boolean bl) {
        String string2 = bl ? TestRunExecutionData.getCurrentTestRunExecutionId() + "-" : "";
        string2 = string2.concat(string);
        return new File(this.startupDirectory, string2);
    }

    private void cleanUpProperties() {
        this.deleteFileOnExit(this.getExecutionPropertiesFile("testrun.properties", false));
        this.deleteFileOnExit(this.getExecutionPropertiesFile("testrun.properties", true));
        this.deleteFileOnExit(this.getExecutionPropertiesFile("agent-info.properties", false));
        this.deleteFileOnExit(this.getExecutionPropertiesFile("agent-info.properties", true));
    }

    private void deleteFileOnExit(File file) {
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    public File getOutFile() {
        return this.outFile;
    }

    public File getErrorFile() {
        return this.errFile;
    }

    public static void putDebugModeCompletedId(String string2, int n2, String string3) {
        List list = ExecuteFramework.getCompletedDebugMode((String)string3).computeIfAbsent(string2, string -> new ArrayList());
        if (!list.contains(n2)) {
            list.add(n2);
            logger.info("Framework : {} completed in debug mode for test run execution : {}. DebugModeCompletedIds : {}", new Object[]{string2, n2, debugModeCompletedIds});
        } else {
            logger.info("TestRunExecution id : {} already there for Framework : {}. DebugModeCompletedIds : {}", new Object[]{n2, string2, debugModeCompletedIds});
        }
    }

    public static int getFirstDebugModeCompletedId(String string, String string2) {
        int n2 = 0;
        List list = (List)ExecuteFramework.getCompletedDebugMode((String)string2).get(string);
        if (list != null && !list.isEmpty()) {
            n2 = (Integer)list.get(0);
        }
        logger.info("DebugModecompleted id for framework : {} is {}. All debugModeCompleted Id : {}", new Object[]{string, n2, debugModeCompletedIds});
        return n2;
    }

    public static void removeDebugModeCompletedFramework(String string, String string2) {
        if (ExecuteFramework.getCompletedDebugMode((String)string2).containsKey(string)) {
            List list = (List)ExecuteFramework.getCompletedDebugMode((String)string2).remove(string);
            logger.info("Removing all tre ids for framework : {} from debug map. Removed ids : {}. All debugModeCompletedIds : {}", new Object[]{string, list, debugModeCompletedIds});
        } else {
            logger.info("Debugmode completed id doesn't contains framework : {}. All debugModeCompletedIds : {}", (Object)string, (Object)debugModeCompletedIds);
        }
    }

    private static Map<String, List<Integer>> getCompletedDebugMode(String string2) {
        return debugModeCompletedIds.computeIfAbsent(string2, string -> new HashMap());
    }

    public static void removeDebugModeCompletedId(String string, int n2, String string2) {
        if (ExecuteFramework.getCompletedDebugMode((String)string2).containsKey(string)) {
            int n3 = 0;
            List list = (List)ExecuteFramework.getCompletedDebugMode((String)string2).get(string);
            if (list != null && list.contains(n2)) {
                list.remove((Object)n2);
                logger.info("Removing the test run execution id : {} from DebugModeCompletedIds for framework : {}. DebugmodeCompletedIds : {}", new Object[]{n2, string, debugModeCompletedIds});
            } else {
                logger.info("Test Run execution id : {} is not debugging the framework : {}. But treId {} is", new Object[]{n2, string, n3});
            }
        } else {
            logger.info("Debugmode completed id doesn't contains framework : {}. All debugModeCompletedIds : {}", (Object)string, (Object)debugModeCompletedIds);
        }
    }

    public static Map<String, List<Integer>> getAllDebugModeCompletedId(String string) {
        logger.info("All debug mode completed Ids : {}", (Object)debugModeCompletedIds);
        return ExecuteFramework.getCompletedDebugMode((String)string);
    }

    static /* synthetic */ String access$000(ExecuteFramework executeFramework) {
        return executeFramework.agentId;
    }

    static /* synthetic */ int access$100(ExecuteFramework executeFramework) {
        return executeFramework.currentTestRunExecutionId;
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }

    static /* synthetic */ String access$300(ExecuteFramework executeFramework) {
        return executeFramework.frameworkName;
    }

    static /* synthetic */ String access$400(ExecuteFramework executeFramework) {
        return executeFramework.browserName;
    }

    static /* synthetic */ boolean access$500(ExecuteFramework executeFramework) {
        return executeFramework.isDebugMode;
    }

    static /* synthetic */ FrameworkQueueDetails access$600(ExecuteFramework executeFramework) {
        return executeFramework.frameworkQueueDetail;
    }
}

