/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.util.ExecuteFramework;
import com.kumaran.tac.agent.util.FrameworkQueueDetails;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.common.enums.TestStepStatus;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompleteTestRunExecution
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(CompleteTestRunExecution.class);
    private boolean initialized = false;
    private FrameworkQueueDetails frameworkQueueDetail;
    private boolean isShutDownFramework = false;
    private CountDownLatch latch = null;
    private String framework = null;
    private Integer testRunExecutionId = null;
    private String agentId = null;

    public CompleteTestRunExecution(FrameworkQueueDetails frameworkQueueDetails, Integer n2, String string) {
        this.frameworkQueueDetail = frameworkQueueDetails;
        this.testRunExecutionId = n2;
        this.agentId = string;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean bl) {
        this.initialized = bl;
        logger.info("Complete Agent thread {}.", (Object)(bl ? "started" : "ended"));
    }

    public void setShutDownFramework(CountDownLatch countDownLatch, String string) {
        this.latch = countDownLatch;
        this.framework = string;
        this.isShutDownFramework = true;
    }

    private void setShutDownFlag(boolean bl) {
        this.isShutDownFramework = bl;
    }

    private void resetShutdownFramework() {
        this.latch = null;
        this.framework = null;
    }

    @Override
    public void run() {
        TestRunExecutionData.setCurrentTestRunExecutionId((int)this.testRunExecutionId);
        LoadConfigFile.setAgentId((String)this.agentId);
        if (!this.isInitialized()) {
            this.setInitialized(true);
            if (this.isShutDownFramework) {
                this.shutdownFramework(this);
            } else {
                logger.info("Complete triggered, agentId : {}", (Object)this.agentId);
                this.completeAllFramework();
            }
            this.setInitialized(false);
            TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
            testRunExecutionData.setTestRunCleanupRunning(false);
        } else {
            logger.debug("Completed thread already started with shutdownFramework flag : {}", (Object)this.isShutDownFramework);
        }
        this.frameworkQueueDetail.clear();
    }

    public void completeAllFramework() {
        int n2 = 0;
        int n3 = ExecuteFramework.getFrameworkStatus((String)this.agentId).size();
        logger.info("Initiating complete all frameworks, agentId : {},totalSize : {}", (Object)this.agentId, (Object)n3);
        TestStepStatus testStepStatus = TestRunExecutionData.getTestRunExecutionData().getLastStepStatus();
        while (n3 != n2) {
            try {
                String string;
                BlockingQueue blockingQueue = TestRunExecutionData.getTestRunExecutionData().getCompletedFrameworks(this.agentId);
                logger.info("Completed queue, agentId : {},queue :{}", (Object)this.agentId, (Object)blockingQueue);
                while ((string = (String)this.frameworkQueueDetail.getCompletedFrameworks().poll(100L, TimeUnit.MILLISECONDS)) == null) {
                }
                String string2 = (String)ExecuteFramework.getFrameworkStatus((String)this.agentId).get(string);
                if (string2 != null && !string2.equals("WAIT_ON_DEBUG")) {
                    ExecuteFramework.getFrameworkStatus((String)this.agentId).remove(string);
                    logger.info("Framework : {} removed from map and its status : {}. Framework status : {}", new Object[]{string, string2, ExecuteFramework.getFrameworkStatus((String)this.agentId)});
                } else {
                    logger.info("Framework : {} not removed from map because of last step status is :{} and  its  FW status : {}", new Object[]{string, testStepStatus, string2});
                }
                logger.info("Frameworks completed {} out of {}", (Object)(++n2), (Object)n3);
            }
            catch (InterruptedException interruptedException) {
                logger.error("Error occurred ", (Throwable)interruptedException);
            }
        }
        logger.info("Sending complete message to server, agentId : {}", (Object)this.agentId);
        this.frameworkQueueDetail.sendCompletedMessageToServer(this.testRunExecutionId, TestStepStatus.COMPLETED);
    }

    public void shutdownFramework(CompleteTestRunExecution completeTestRunExecution) {
        this.setShutDownFlag(false);
        if (completeTestRunExecution.latch != null && completeTestRunExecution.framework != null) {
            try {
                while (true) {
                    logger.info("Waiting for framework : {} to shutdown", (Object)this.framework);
                    String string = (String)this.frameworkQueueDetail.getCompletedFrameworks().poll(100L, TimeUnit.MILLISECONDS);
                    if (string != null && string.equalsIgnoreCase(completeTestRunExecution.framework)) {
                        completeTestRunExecution.latch.countDown();
                        this.resetShutdownFramework();
                        logger.info("Framework : {} get shutdown successfully.", (Object)string);
                    }
                    logger.warn("Framework : {} get shutdown", (Object)string);
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error("Error occurred ", (Throwable)interruptedException);
            }
        } else {
            logger.error("Unable to start shutdown process may be either latch or framework name is null. Latch : {}, FrameworkName :{} ", (Object)this.latch, (Object)this.framework);
        }
    }
}

