/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.AgentExecutor;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.common.dto.AttributeStatusDTO;
import com.kumaran.tac.common.dto.AttributeStatusDTOWrapper;
import com.kumaran.tac.common.dto.ValidationStatusResultWrapper;
import com.kumaran.tac.common.support.IAsyncUpdateDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class AsyncUpdaterThread
extends Thread {
    public static final Logger logger = LoggerFactory.getLogger(AsyncUpdaterThread.class);
    @Autowired
    AgentService agentService;
    private volatile boolean exitFlag = false;
    Map<Class<? extends IAsyncUpdateDTO>, List<IAsyncUpdateDTO>> bucket = new HashMap();
    Map<Class<? extends IAsyncUpdateDTO>, AtomicInteger> countMap = new ConcurrentHashMap();
    BlockingQueue<IAsyncUpdateDTO> queue = new LinkedBlockingQueue();
    AgentExecutor agentExecutor;
    private Thread thread;

    public AsyncUpdaterThread(AgentExecutor agentExecutor) {
        this.agentExecutor = agentExecutor;
    }

    public void stopProcessing() {
        this.exitFlag = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (Exception exception) {
                logger.error("Error while joining the async updater.", (Throwable)exception);
            }
        }
        logger.info("AsyncUpdaterThread - Stop signalled.");
    }

    @Override
    public void run() {
        LoadConfigFile.setAgentId((String)this.agentExecutor.getAgentId());
        this.thread = Thread.currentThread();
        block4: while (true) {
            try {
                while (true) {
                    Collection<Object> collection;
                    IAsyncUpdateDTO iAsyncUpdateDTO;
                    if ((iAsyncUpdateDTO = (IAsyncUpdateDTO)this.queue.poll(300L, TimeUnit.MILLISECONDS)) != null) {
                        collection = this.bucket.computeIfAbsent(iAsyncUpdateDTO.getClass(), clazz -> new ArrayList());
                        collection.add(iAsyncUpdateDTO);
                        this.decrementSize(iAsyncUpdateDTO);
                        continue;
                    }
                    if (this.bucket.size() != 0) {
                        collection = new HashSet();
                        collection.addAll(this.bucket.keySet());
                        for (Class clazz2 : collection) {
                            List list = (List)this.bucket.get(clazz2);
                            try {
                                if (AttributeStatusDTOWrapper.class.isAssignableFrom(clazz2)) {
                                    this.agentService.sendAttributeStatus(list);
                                } else if (ValidationStatusResultWrapper.class.isAssignableFrom(clazz2)) {
                                    this.agentService.sendValidationStatusResultRequest(list);
                                }
                                this.bucket.remove(clazz2);
                            }
                            catch (Exception exception) {
                                logger.error("Error performing async update activity", (Throwable)exception);
                            }
                        }
                        this.bucket.clear();
                    }
                    if (this.exitFlag && this.queue.isEmpty()) {
                        logger.info("AsyncUpdaterThread - Stoped.");
                        break block4;
                    }
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (Exception exception) {
                logger.error("Error in Attribute Status", (Throwable)exception);
                continue;
            }
            break;
        }
    }

    private void incrementSize(IAsyncUpdateDTO iAsyncUpdateDTO) {
        AtomicInteger atomicInteger = this.countMap.computeIfAbsent(iAsyncUpdateDTO.getClass(), clazz -> new AtomicInteger(0));
        atomicInteger.incrementAndGet();
    }

    private void decrementSize(IAsyncUpdateDTO iAsyncUpdateDTO) {
        AtomicInteger atomicInteger = this.countMap.computeIfAbsent(iAsyncUpdateDTO.getClass(), clazz -> new AtomicInteger(0));
        int n2 = atomicInteger.decrementAndGet();
        if (n2 < 0) {
            logger.error("[DEVELOPER ERROR] The counter cannot be lesser than 0. Please validate.");
        }
    }

    public void addAttributeStatus(AttributeStatusDTO attributeStatusDTO, Integer n2) throws InterruptedException {
        AttributeStatusDTOWrapper attributeStatusDTOWrapper = new AttributeStatusDTOWrapper(n2, attributeStatusDTO);
        this.incrementSize((IAsyncUpdateDTO)attributeStatusDTOWrapper);
        this.queue.put(attributeStatusDTOWrapper);
    }

    public void addValidationStatusResult(Map<String, Object> map) throws InterruptedException {
        ValidationStatusResultWrapper validationStatusResultWrapper = new ValidationStatusResultWrapper(map);
        this.incrementSize((IAsyncUpdateDTO)validationStatusResultWrapper);
        this.queue.put(validationStatusResultWrapper);
    }

    public void waitForPendingItems(Class<? extends IAsyncUpdateDTO> clazz) {
        AtomicInteger atomicInteger = (AtomicInteger)this.countMap.get(clazz);
        if (atomicInteger == null || atomicInteger.get() == 0) {
            return;
        }
        while (atomicInteger.get() != 0 || this.bucket.containsKey(clazz)) {
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

