/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kumaran.tac.agent.AgentApplication;
import com.kumaran.tac.agent.dto.UnregisterdAgentInfo;
import com.kumaran.tac.agent.service.AgentRegistrationService;
import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.service.FileBrowserService;
import com.kumaran.tac.agent.util.AgentAdminExecutor;
import com.kumaran.tac.agent.util.AgentExecutor;
import com.kumaran.tac.agent.util.AsyncUpdaterThread;
import com.kumaran.tac.agent.util.FrameworkQueueDetails;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.MasterAgentExecutor;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.agent.util.TestRunLogger;
import com.kumaran.tac.common.dto.AgentCommand;
import com.kumaran.tac.common.dto.FileListResponseDto;
import com.kumaran.tac.common.dto.PreviewResponseDto;
import com.kumaran.tac.common.enums.AgentCommandMessage;
import com.kumaran.tac.common.enums.Browser;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.messages.MessageUtils;
import com.kumaran.tac.common.util.AutowireHelperUtil;
import com.kumaran.tac.common.util.CommonUtility;
import com.kumaran.tac.common.util.EncryptUtil;
import com.kumaran.tac.common.windows.WindowsBrowserUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.Scheduled;

public class AgentExecutor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AgentExecutor.class);
    private BlockingQueue<String> serverCallTriggerQueue = new LinkedBlockingQueue();
    private Map<Integer, Executor> executorMap = new ConcurrentHashMap();
    private final Map<Integer, TestRunLogger> loggerMap = new ConcurrentHashMap();
    boolean flag = true;
    private Thread thread;
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    AgentService agentService;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    AgentRegistrationService agentRegistrationService;
    @Autowired
    RestUtil restUtil;
    @Autowired
    @Qualifier(value="taskExecutor")
    TaskExecutor executor;
    @Autowired
    FileBrowserService fileBrowserService;
    boolean isFirstRequestToServer = true;
    boolean isHeartBeatProcessed = true;
    boolean isAgentAdminExecutorRunning = false;
    String agentId;
    private FrameworkQueueDetails frameworkQueueDetail;
    private AgentAdminExecutor agentAdminExecutor;
    private AsyncUpdaterThread asyncUpdaterThread;
    private CountDownLatch initializeLatch = new CountDownLatch(1);

    public AgentExecutor(String string) {
        this.agentId = string;
    }

    public AgentExecutor() {
    }

    public FrameworkQueueDetails getFrameworkQueueDetail() {
        return this.frameworkQueueDetail;
    }

    public Map<Integer, TestRunLogger> getLoggerMap() {
        return this.loggerMap;
    }

    public AsyncUpdaterThread getAsyncUpdaterThread() {
        return this.asyncUpdaterThread;
    }

    public Map<Integer, Executor> getExecutorMap() {
        return this.executorMap;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void stop() {
        this.flag = false;
        if (this.agentAdminExecutor != null) {
            this.agentAdminExecutor.stopExecution();
        }
        if (this.asyncUpdaterThread != null) {
            this.asyncUpdaterThread.stopProcessing();
        }
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (Exception exception) {
                logger.error("Error while joining the agent status.", (Throwable)exception);
            }
        }
        logger.info("Agent executor - Stopped.");
    }

    public void clearServerCallTriggerQueue() {
        this.serverCallTriggerQueue.clear();
        logger.info("Clearing the server call queue");
    }

    public void waitUntilFrameworkCompletesAStep() throws InterruptedException {
        String string = null;
        while (true) {
            if ((string = (String)this.serverCallTriggerQueue.poll(5L, TimeUnit.MINUTES)) != null) break;
            logger.info("Framework is executing the a step. Waiting to complete");
        }
        logger.info("Framework completed a step with msg : {}. Fetching new step from server.", (Object)string);
    }

    public void pollServerTriggerQueue(boolean bl) {
        if (bl) {
            return;
        }
        try {
            long l2 = 5L;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            this.serverCallTriggerQueue.poll(l2, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void addMessageToServerCallQueue(String string, String string2) throws InterruptedException {
        this.serverCallTriggerQueue.put(string);
        logger.info("Adding message : {} to the server call queue,agentId : {}", (Object)string, (Object)string2);
    }

    @Override
    public void run() {
        LoadConfigFile.getInstance();
        this.thread = Thread.currentThread();
        LoadConfigFile.setAgentId((String)this.agentId);
        this.agentAdminExecutor = this.getAgentAdminExecutor(this);
        this.frameworkQueueDetail = this.getFrameworkQueueDetails(this);
        this.asyncUpdaterThread = this.getAsyncUpdaterThread(this);
        this.executor.execute((Runnable)this.asyncUpdaterThread);
        Browser browser = Browser.CHROME;
        if (CommonUtility.isMac()) {
            browser = Browser.SAFARI;
        }
        String string = LoadConfigFile.getInstance().getServerUrl();
        String string2 = LoadConfigFile.getInstance().getPropertyAsString("agent.tenantId");
        String string3 = "agent/v1/agents/";
        if (string == null || this.agentId == "" || this.agentId == null || string2 == null) {
            string3 = string3 + "0/agentRegistration";
            WindowsBrowserUtil.openBrowserProfile((Browser)browser, (String)string3);
        } else {
            string3 = string3 + this.agentId + "/launch";
            WindowsBrowserUtil.openBrowserProfile((Browser)browser, (String)string3);
        }
        boolean bl = false;
        try {
            this.clearServerCallTriggerQueue();
            String string4 = "";
            boolean bl2 = false;
            String string5 = null;
            while (this.flag) {
                try {
                    if (bl && AgentApplication.checkVersionUpgrade() && this.frameworkQueueDetail != null && !this.frameworkQueueDetail.isAnyTestrunRunning() && !this.frameworkQueueDetail.isAnyTestRunCleanupRunning()) {
                        this.agentService.checkAgentUpdate(true, this.agentId);
                        AgentApplication.checkVersionUpgrade((boolean)false);
                    }
                    if (bl && AgentApplication.getRestartAgentForUpdate() && this.frameworkQueueDetail != null && !this.frameworkQueueDetail.isAnyTestrunRunning() && !this.frameworkQueueDetail.isAnyTestRunCleanupRunning()) {
                        AgentApplication.setRestartAgentForUpdate((boolean)false);
                        AgentApplication.shutdown((int)200);
                        break;
                    }
                    if (!MasterAgentExecutor.isServerUrlExists()) {
                        string4 = LoadConfigFile.getInstance().getServerUrl();
                        string5 = LoadConfigFile.getInstance().getPropertyAsString("agent.tenantId");
                    }
                    if (string4 == null || this.agentId == null || string5 == null) {
                        if (bl2) continue;
                        logger.error("One or more of: Server URL ({}), AgentID ({}) or Tenant Id ({}) is/are missing.", new Object[]{string4, this.agentId, string5});
                        bl2 = true;
                        continue;
                    }
                    if (this.isFirstRequestToServer) {
                        bl = true;
                        logger.info("Agent Configuration: Server URL ({}), AgentID ({}), Tenant Id ({})", new Object[]{string4, this.agentId, string5});
                        this.agentService.checkAgentUpdate(true, this.agentId);
                        AgentApplication.checkVersionUpgrade((boolean)false);
                        if (!this.restUtil.wasServerAccessFailed()) {
                            this.agentService.sendAgentStartedMessageToServer(this.agentId);
                            if (!this.restUtil.wasServerAccessFailed()) {
                                TestRunLogger.uploadOldTestRunLogs((String)this.agentId, (Map)this.loggerMap);
                                this.isFirstRequestToServer = false;
                                this.initializeLatch.countDown();
                            }
                        }
                    }
                    if (!this.restUtil.isAuthenticated()) {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                        continue;
                    }
                    if (!this.isAgentAdminExecutorRunning) {
                        this.executor.execute((Runnable)this.agentAdminExecutor);
                        this.isAgentAdminExecutorRunning = true;
                    }
                    bl2 = false;
                    logger.info("Communicate serverWeb and get next agent command.");
                    AgentCommand agentCommand = this.agentService.getNextCommand(this.agentId);
                    if (agentCommand != null) {
                        logger.info("agentCommand: {}", (Object)agentCommand);
                        this.processAgentCommand(this.agentId, agentCommand);
                        if (this.frameworkQueueDetail != null && this.frameworkQueueDetail.isCurrentTestRunning()) {
                            logger.info("Waiting on framework to complete step to initate Server Call");
                            this.waitUntilFrameworkCompletesAStep();
                            continue;
                        }
                        this.pollServerTriggerQueue(this.frameworkQueueDetail != null && this.frameworkQueueDetail.isCurrentTestRunning());
                        continue;
                    }
                    this.pollServerTriggerQueue(this.frameworkQueueDetail != null && this.frameworkQueueDetail.isCurrentTestRunning());
                }
                catch (TACException tACException) {
                    logger.error("Inside AgentExecutor.run.while.TACException: {}", (Object)tACException.getMessage());
                }
                catch (Exception exception) {
                    logger.error("Inside AgentExecutor.run.while: ", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            logger.error("Inside AgentExecutor.run: ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dqvConnect(AgentCommand agentCommand) {
        if (agentCommand.getData() == null || !Boolean.TRUE.equals(agentCommand.getData().getOrDefault("connection", Boolean.FALSE))) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object object = null;
        try {
            Object object2;
            String string = (String)agentCommand.getData().get("connectionType");
            Map map = (Map)agentCommand.getData().get("connectionDetails");
            String string2 = (String)agentCommand.getData().get("dqvMethod");
            if (map != null) {
                if (map.get("password") != null && ((String)(object2 = (String)map.get("password"))).startsWith("ENC(")) {
                    object2 = ((String)object2).replace("ENC(", "").replace(")", "");
                    map.put("password", EncryptUtil.decrypt((String)object2));
                }
                map = (Map)EncryptUtil.decryptTestDataObjectValue((String)String.valueOf(this.agentId), (Object)map);
            }
            object2 = MasterAgentExecutor.getDqvClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)object2);
            Class<?> clazz = Class.forName("com.kumaran.data.comparison.DataQualityValidator", true, (ClassLoader)object2);
            Class[] classArray = new Class[]{String.class, Map.class};
            Method method = clazz.getMethod(string2, classArray);
            try {
                object = method.invoke(null, string, map);
            }
            catch (Exception exception) {
                logger.error("Error occurred during method invocation: ", (Throwable)exception);
                Thread.currentThread().setContextClassLoader(classLoader);
                return;
            }
        }
        catch (Throwable throwable) {
            logger.error("Error occurred during reflection operation: ", throwable);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        if (object != null) {
            this.restUtil.postData("agents/" + this.agentId + "/" + agentCommand.getCorrelationId() + "/reflection/result", object, String.class);
        } else {
            logger.debug("The result of PopulateFields is: {}", object);
        }
    }

    public void processAgentCommand(String string, AgentCommand agentCommand) {
        if (agentCommand == null) {
            return;
        }
        AgentCommandMessage agentCommandMessage = agentCommand.getMsg();
        if (agentCommandMessage == AgentCommandMessage.UpdateAgentProperites) {
            this.agentService.updateAgentProperties(agentCommand.getData(), string);
        } else if (agentCommandMessage == AgentCommandMessage.GetAgentProperties) {
            this.agentService.sendAgentPropertiesToServer(agentCommand);
        } else if (agentCommandMessage == AgentCommandMessage.UnregisterAgent) {
            this.agentRegistrationService.unregisterConfirmation(string, this.unregisterAndSendStatus());
        } else if (agentCommandMessage == AgentCommandMessage.UpgradeVersion) {
            AgentApplication.checkVersionUpgrade((boolean)true);
        } else if (agentCommandMessage == AgentCommandMessage.TestRunExecution || agentCommandMessage == AgentCommandMessage.FrameworkShutdown || agentCommandMessage == AgentCommandMessage.StartDebug || agentCommandMessage == AgentCommandMessage.StopDebug) {
            Executor executor = this.getOrCreateExecutor(string, agentCommand);
            executor.addAgentCommand(agentCommand);
        } else if (agentCommandMessage == AgentCommandMessage.Pause) {
            Executor executor = this.getOrCreateExecutor(string, agentCommand);
            executor.pause();
        } else if (agentCommandMessage == AgentCommandMessage.Resume) {
            Executor executor = this.getOrCreateExecutor(string, agentCommand);
            executor.resume();
        } else if (agentCommandMessage == AgentCommandMessage.DQVConnection) {
            this.dqvConnect(agentCommand);
        } else if (agentCommandMessage == AgentCommandMessage.FileBrowseList) {
            this.handleFileBrowseList(string, agentCommand);
        } else if (agentCommandMessage == AgentCommandMessage.FileBrowsePreview) {
            this.handleFileBrowsePreview(string, agentCommand);
        } else {
            logger.error("Unknown Command: {}", (Object)agentCommand);
        }
    }

    private void handleFileBrowseList(String string, AgentCommand agentCommand) {
        String string2 = null;
        try {
            Map map = agentCommand.getData();
            string2 = (String)map.get("path");
            FileListResponseDto fileListResponseDto = this.fileBrowserService.listFiles(string2);
            this.restUtil.postData("agents/" + string + "/" + agentCommand.getCorrelationId() + "/reflection/result", (Object)fileListResponseDto, String.class);
        }
        catch (Exception exception) {
            logger.error("Error handling file browse list command", (Throwable)exception);
            FileListResponseDto fileListResponseDto = new FileListResponseDto();
            fileListResponseDto.setCurrentPath(string2 != null ? string2 : "");
            fileListResponseDto.setParentPath(null);
            fileListResponseDto.setItems(new ArrayList());
            this.restUtil.postData("agents/" + string + "/" + agentCommand.getCorrelationId() + "/reflection/result", (Object)fileListResponseDto, String.class);
        }
    }

    private void handleFileBrowsePreview(String string, AgentCommand agentCommand) {
        try {
            Map map = agentCommand.getData();
            String string2 = (String)map.get("path");
            Integer n2 = map.getOrDefault("lines", 20);
            PreviewResponseDto previewResponseDto = this.fileBrowserService.previewFile(string2, n2.intValue());
            this.restUtil.postData("agents/" + string + "/" + agentCommand.getCorrelationId() + "/reflection/result", (Object)previewResponseDto, String.class);
        }
        catch (Exception exception) {
            logger.error("Error handling file browse preview command", (Throwable)exception);
            PreviewResponseDto previewResponseDto = new PreviewResponseDto();
            previewResponseDto.setSuccess(false);
            previewResponseDto.setError("Preview not available: " + exception.getMessage());
            this.restUtil.postData("agents/" + string + "/" + agentCommand.getCorrelationId() + "/reflection/result", (Object)previewResponseDto, String.class);
        }
    }

    private Executor getOrCreateExecutor(String string, AgentCommand agentCommand) {
        int n2 = agentCommand.getTestRunExecutionId();
        return this.executorMap.computeIfAbsent(n2, n3 -> new Executor(this, n2, this.agentService, this.restUtil, this.frameworkQueueDetail, string));
    }

    public void pause() {
        this.executorMap.values().forEach(Executor::pause);
    }

    public void resume() {
        this.executorMap.values().forEach(Executor::resume);
    }

    private UnregisterdAgentInfo unregisterAndSendStatus() {
        UnregisterdAgentInfo unregisterdAgentInfo = new UnregisterdAgentInfo();
        try {
            this.frameworkQueueDetail.abortTestRun(true, MessageUtils.getMessage((String)"ABORT_MESSAGE_UNREGISTER"));
            unregisterdAgentInfo = this.agentRegistrationService.unregisterAgent();
        }
        catch (Exception exception) {
            CommonUtility.exceptionMessageLogger((String)"Inside unregisterAndSendStatus(): ", (Throwable)exception);
        }
        return unregisterdAgentInfo;
    }

    @Scheduled(cron="*/60 * * * * ?")
    public void heartBeat() {
        LoadConfigFile.setAgentId((String)this.agentId);
        if (!this.isFirstRequestToServer) {
            String string = "/agents/" + this.agentId + "/heartbeat";
            String string2 = (String)this.restUtil.getData(string, String.class);
            if ("success".equalsIgnoreCase(string2)) {
                if (!this.isHeartBeatProcessed) {
                    logger.info("Agent hearbeat is successfully processed by server");
                }
                this.isHeartBeatProcessed = true;
            } else if (this.isHeartBeatProcessed) {
                logger.error("Agent hearbeat was not processed by server");
                this.isHeartBeatProcessed = false;
            }
        }
    }

    private AgentAdminExecutor getAgentAdminExecutor(AgentExecutor agentExecutor) {
        try {
            return (AgentAdminExecutor)AutowireHelperUtil.getBeanByConstructorParams((String)"agentAdminExecutor", (Object[])new Object[]{agentExecutor});
        }
        catch (Exception exception) {
            logger.error("Error while obtaining the AgentAdminExecutor bean", (Throwable)exception);
            return null;
        }
    }

    private FrameworkQueueDetails getFrameworkQueueDetails(AgentExecutor agentExecutor) {
        try {
            return (FrameworkQueueDetails)AutowireHelperUtil.getBeanByConstructorParams((String)"frameworkQueueDetails", (Object[])new Object[]{agentExecutor});
        }
        catch (Exception exception) {
            logger.error("Error while obtaining the FrameworkQueueDetails bean", (Throwable)exception);
            return null;
        }
    }

    private AsyncUpdaterThread getAsyncUpdaterThread(AgentExecutor agentExecutor) {
        try {
            return (AsyncUpdaterThread)AutowireHelperUtil.getBeanByConstructorParams((String)"asyncUpdaterThread", (Object[])new Object[]{agentExecutor});
        }
        catch (Exception exception) {
            logger.error("Error while obtaining the FrameworkQueueDetails bean", (Throwable)exception);
            return null;
        }
    }

    public void waitForInitialization() {
        try {
            while (this.flag && !this.initializeLatch.await(5L, TimeUnit.SECONDS)) {
                logger.info("First agent initialization is in progress...");
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error("Error waiting for first agent's initialization", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        logger.info("First agent is initialized.");
    }

    public void markAsInitialized() {
        this.isFirstRequestToServer = false;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

