/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.MasterAgentExecutor;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.common.communication.commands.BaseCommand;
import com.kumaran.tac.common.communication.commands.PauseAllExecutionsCommand;
import com.kumaran.tac.common.communication.commands.ResumeAllExecutionsCommand;
import com.kumaran.tac.common.dto.AgentContext;
import com.kumaran.tac.common.dto.ProjectVersionRequestDTO;
import com.kumaran.tac.common.enums.ReferenceDataUnlockType;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.util.AutowireHelperUtil;
import com.kumaran.tac.common.util.CustomExpressions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jexl3.JexlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentCustomExpressions
extends CustomExpressions {
    private static final Logger logger = LoggerFactory.getLogger(AgentCustomExpressions.class);
    private AgentContext agentContext;
    private String projectCode;

    public AgentContext getParameterVariableMap() {
        return this.agentContext;
    }

    public void setParameterVariableMap(AgentContext agentContext) {
        this.agentContext = agentContext;
    }

    public AgentCustomExpressions(boolean bl, String string) {
        super(bl);
        this.projectCode = string;
    }

    public AgentCustomExpressions(boolean bl, String string, AgentContext agentContext) {
        super(bl);
        this.projectCode = string;
        this.agentContext = agentContext;
    }

    public String currentBrowser() throws Exception {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return (String)testRunExecutionData.getCurrentTACValues().get("tac_current_browser");
    }

    public String currentAgent() throws Exception {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return (String)testRunExecutionData.getCurrentTACValues().get("tac_current_agent");
    }

    public String currentTool() throws Exception {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return (String)testRunExecutionData.getCurrentTACValues().get("tac_current_tool");
    }

    public String currentEnvironment() throws Exception {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return (String)testRunExecutionData.getCurrentTACValues().get("tac_current_environment");
    }

    private boolean isTacAutVersion(Object object, String string, String string2, CustomExpressions.CompareMethod compareMethod, String string3, String string4) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        ProjectVersionRequestDTO projectVersionRequestDTO = new ProjectVersionRequestDTO(object, string);
        List list = agentService.getAutVersionOrdersFromServer(projectVersionRequestDTO);
        list = this.convertAllToLowercase(list);
        return this.compareVersions(compareMethod, string3, string2, string4, list);
    }

    private boolean isTacAutVersionByProjectCode(CustomExpressions.CompareMethod compareMethod, String string, String string2, String string3) throws Exception {
        return this.isTacAutVersion((Object)string, "project_code", string2, compareMethod, string, string3);
    }

    private boolean isTacAutVersionByProjectCode(CustomExpressions.CompareMethod compareMethod, String string, String string2) throws Exception {
        String string3 = this.tacAutVersion(string);
        return this.isTacAutVersionByProjectCode(compareMethod, string, string3, string2);
    }

    public boolean tacAutVersionIsBefore(String string, String string2) throws Exception {
        return this.isTacAutVersionByProjectCode(CustomExpressions.CompareMethod.BEFORE, string, string2);
    }

    public boolean tacAutVersionIsAfter(String string, String string2) throws Exception {
        return this.isTacAutVersionByProjectCode(CustomExpressions.CompareMethod.AFTER, string, string2);
    }

    public boolean tacAutVersionIsBefore(String string) throws Exception {
        String string2 = this.tacAutVersion(this.projectCode);
        return this.isTacAutVersionByProjectCode(CustomExpressions.CompareMethod.BEFORE, this.projectCode, string2, string);
    }

    public boolean tacAutVersionIsAfter(String string) throws Exception {
        String string2 = this.tacAutVersion(this.projectCode);
        return this.isTacAutVersionByProjectCode(CustomExpressions.CompareMethod.AFTER, this.projectCode, string2, string);
    }

    public Number nextNumberFrom(String string) throws Exception {
        return this.nextNumberFromProject(null, string);
    }

    public Number nextNumberFromProject(String string, String string2) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        return agentService.getNextNumericValue(string, string2);
    }

    public Number currentNumberFrom(String string) throws Exception {
        return this.currentNumberFromProject(null, string);
    }

    public Number currentNumberFromProject(String string, String string2) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        return agentService.getCurrentNumericValue(string, string2);
    }

    public String currentTextFrom(String string) throws Exception {
        return this.currentTextFromProject(null, string);
    }

    public String currentTextFromProject(String string, String string2) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        String string3 = null;
        try {
            string3 = agentService.getCurrentTextValue(string, string2);
            return string3 == null ? "" : string3;
        }
        catch (TACException tACException) {
            throw tACException;
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                throw new TACException(exception.getMessage(), (Throwable)exception);
            }
            throw new TACException("Exception occured while reading reference data", (Throwable)exception);
        }
    }

    public String nextTextFrom(String string) throws Exception {
        return this.nextTextFromProject(this.projectCode, string, ReferenceDataUnlockType.NONE, null);
    }

    public String nextTextFromProject(String string, String string2, ReferenceDataUnlockType referenceDataUnlockType, String string3) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        String string4 = null;
        try {
            string4 = agentService.getNextTextValue(string, string2, referenceDataUnlockType, string3);
            return string4 == null ? "" : string4;
        }
        catch (TACException tACException) {
            throw tACException;
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                throw new TACException(exception.getMessage(), (Throwable)exception);
            }
            throw new TACException("Exception occured while reading reference data", (Throwable)exception);
        }
    }

    public String lockStatus(String string) throws Exception {
        return this.lockStatus(null, string);
    }

    public String lockStatus(String string, String string2) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        String string3 = null;
        try {
            string3 = agentService.lockStatus(string, string2);
            return string3 == null ? "" : string3;
        }
        catch (TACException tACException) {
            throw tACException;
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                throw new TACException(exception.getMessage(), (Throwable)exception);
            }
            throw new TACException("Exception occured while reading reference data", (Throwable)exception);
        }
    }

    public String lockStatusForItem(String string, String string2) throws Exception {
        return this.lockStatusForItem(null, string, string2);
    }

    public String lockStatusForItem(String string, String string2, String string3) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        String string4 = null;
        try {
            string4 = agentService.lockStatus(string, string2, string3);
            return string4 == null ? "" : string4;
        }
        catch (TACException tACException) {
            throw tACException;
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                throw new TACException(exception.getMessage(), (Throwable)exception);
            }
            throw new TACException("Exception occured while reading reference data", (Throwable)exception);
        }
    }

    public String waitLock(String string, int n2, ReferenceDataUnlockType referenceDataUnlockType, String string2) throws Exception {
        String string3 = null;
        try {
            long l2 = System.currentTimeMillis() + (long)(n2 * 1000);
            while ((string3 = string2 != null ? this.nextTextFromProject(null, string, referenceDataUnlockType, string2) : this.nextTextFromProject(null, string, referenceDataUnlockType, null)).length() <= 0 && System.currentTimeMillis() < l2) {
                TimeUnit.SECONDS.sleep(1L);
            }
            if (string3 == null || string3.isEmpty()) {
                String string4 = " for: '" + string + "', unlockOn: " + referenceDataUnlockType + ", TextValue: '" + string2 + "'";
                if (n2 != -1) {
                    throw new TACException("Timeout exceeded - Unable to get the reference data" + string4);
                }
                throw new TACException("Unable to get the reference data" + string4);
            }
        }
        catch (TACException tACException) {
            throw tACException;
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("Timeout")) {
                throw new TACException("Timeout exceeded - Unable to get the reference data " + exception);
            }
            if (exception.getMessage() != null && exception.getMessage().contains("ReferenceData")) {
                throw new TACException(exception.getMessage() + exception);
            }
            throw new TACException("Error reading nextTextValue for: '" + string + "'", (Throwable)exception);
        }
        return string3;
    }

    public String getNextTextFrom(String string) throws Exception {
        return this.nextTextFromProject(null, string, null, null);
    }

    public String waitLockAndGetNextTextFrom(String string) throws Exception {
        return this.waitLock(string, -1, ReferenceDataUnlockType.TESTCASE_END, null);
    }

    public String waitLockAndGetNextTextFrom(String string, int n2) throws Exception {
        return this.waitLock(string, n2, ReferenceDataUnlockType.TESTCASE_END, null);
    }

    public String waitLockAndGetNextTextFrom(String string, int n2, String string2) throws Exception {
        return this.waitLock(string, n2, ReferenceDataUnlockType.getUnlockType((String)string2), null);
    }

    public String waitLockAndGetNextTextFrom(String string, String string2) throws Exception {
        return this.waitLock(string, -1, ReferenceDataUnlockType.TESTCASE_END, string2);
    }

    public String waitLockAndGetTextFrom(String string, int n2, String string2) throws Exception {
        return this.waitLock(string, n2, ReferenceDataUnlockType.TESTCASE_END, string2);
    }

    public String waitLockAndGetNextTextFrom(String string, int n2, String string2, String string3) throws Exception {
        return this.waitLock(string, n2, ReferenceDataUnlockType.getUnlockType((String)string2), string3);
    }

    public String unlockReferenceData(String string, String string2) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        return agentService.unlockReferenceTextFromProject(this.projectCode, string, string2);
    }

    public String lookup(String string, Object object) throws Exception {
        return this.lookupProject(null, string, object);
    }

    public String lookup(String string, Object object, String string2) throws Exception {
        return this.lookupProject(null, string, object, string2);
    }

    public String lookupProject(String string, String string2, Object object) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        return agentService.getLookupValue(string, string2, object);
    }

    public String lookupProject(String string, String string2, Object object, String string3) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        return agentService.getLookupValue(string, string2, object, string3);
    }

    public Object matrixLookup(String string, Object object, Object object2) throws Exception {
        return this.matrixLookupProject(null, string, object, object2);
    }

    public Object matrixLookup(String string, Object object, Object object2, String string2) throws Exception {
        return this.matrixLookupProject(null, string, object, object2, string2);
    }

    public Object matrixLookupProject(String string, String string2, Object object, Object object2) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        return agentService.getMatrixLookupValue(string, string2, object, object2);
    }

    public Object matrixLookupProject(String string, String string2, Object object, Object object2, String string3) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        return agentService.getMatrixLookupValue(string, string2, object, object2, string3);
    }

    public String testdata(String string) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        String string2 = this.getAttributeCurrentSeq();
        return agentService.getTestDataForAttribute(string, string2);
    }

    public boolean hasTestdata(String ... stringArray) throws Exception {
        AgentService agentService = (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        boolean bl = false;
        String string = this.getAttributeCurrentSeq();
        for (String string2 : stringArray) {
            String string3 = agentService.getTestDataForAttribute(string2, string);
            if (string3 == null || string3.trim().length() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String getAttributeCurrentSeq() {
        return (String)this.agentContext.getParameterVariableMap().get("seq");
    }

    private AgentService getAgentService() {
        try {
            return (AgentService)AutowireHelperUtil.getBeanObj(AgentService.class);
        }
        catch (Exception exception) {
            throw new TACException((Throwable)exception);
        }
    }

    public String generate() throws Exception {
        if (JexlEngine.getThreadContext() != null) {
            Integer n2 = (Integer)JexlEngine.getThreadContext().get("tac_current_attribute_id");
            Objects.requireNonNull(n2, "Attribute id cannot be null to generate test data");
            AgentService agentService = this.getAgentService();
            return agentService.generateTestDataForAttribute(n2.intValue());
        }
        throw new TACException("Unable to generate attribute data");
    }

    public String column(String string) {
        if (this.agentContext != null) {
            if (this.agentContext.getParameterVariableMap() != null) {
                Object v2 = this.agentContext.getParameterVariableMap().get(string);
                if (v2 == null) {
                    return null;
                }
                return v2.toString();
            }
            return "";
        }
        throw new TACException("Error evaluating the column function");
    }

    public boolean pauseAllExecutions() {
        boolean bl = false;
        try {
            MasterAgentExecutor masterAgentExecutor = (MasterAgentExecutor)AutowireHelperUtil.getBeanObj(MasterAgentExecutor.class);
            PauseAllExecutionsCommand pauseAllExecutionsCommand = new PauseAllExecutionsCommand();
            pauseAllExecutionsCommand.setSenderReferenceId("" + LoadConfigFile.getAgentId());
            masterAgentExecutor.pauseAllAgentExecutors((BaseCommand)pauseAllExecutionsCommand);
            bl = true;
        }
        catch (Exception exception) {
            logger.error("Error pausing all agent executors", (Throwable)exception);
        }
        return bl;
    }

    public boolean resumeAllExecutions() {
        boolean bl = false;
        try {
            MasterAgentExecutor masterAgentExecutor = (MasterAgentExecutor)AutowireHelperUtil.getBeanObj(MasterAgentExecutor.class);
            ResumeAllExecutionsCommand resumeAllExecutionsCommand = new ResumeAllExecutionsCommand();
            resumeAllExecutionsCommand.setSenderReferenceId("" + LoadConfigFile.getAgentId());
            masterAgentExecutor.resumeAllAgentExecutors((BaseCommand)resumeAllExecutionsCommand);
            bl = true;
        }
        catch (Exception exception) {
            logger.error("Error resuming all agent executors", (Throwable)exception);
        }
        return bl;
    }
}

