/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.util;

import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.AgentExecutor;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.common.dto.AgentCommand;
import com.kumaran.tac.common.exception.TACException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AgentAdminExecutor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AgentAdminExecutor.class);
    volatile boolean flag = true;
    @Autowired
    AgentService agentService;
    @Autowired
    RestUtil restUtil;
    AgentExecutor agentExecutor;
    private Thread thread;

    public AgentAdminExecutor(AgentExecutor agentExecutor) {
        this.agentExecutor = agentExecutor;
    }

    public void stopExecution() {
        this.flag = false;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (Exception exception) {
                logger.error("Error while joining the admin agent.", (Throwable)exception);
            }
        }
        logger.info("Agent admin executor - Stopped.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String string = this.agentExecutor.getAgentId();
        LoadConfigFile.setAgentId((String)string);
        this.thread = Thread.currentThread();
        try {
            while (this.flag) {
                try {
                    AgentCommand agentCommand = this.agentService.getAdminNextCommand(string);
                    if (agentCommand == null) continue;
                    logger.info("Communicate serverWeb and get next agent admin command.");
                    logger.info("agentAdminCommand: {}", (Object)agentCommand);
                    this.agentExecutor.processAgentCommand(string, agentCommand);
                }
                catch (TACException tACException) {
                    logger.error("Inside AgentAdminExecutor.run.while.TACException: {}", (Object)tACException.getMessage());
                }
                catch (Exception exception) {
                    logger.error("Inside AgentAdminExecutor.run.while: ", (Throwable)exception);
                }
            }
            return;
        }
        catch (Exception exception) {
            logger.error("Inside AgentExecutor.run: ", (Throwable)exception);
        }
    }
}

