/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pjfanning.xlsx.StreamingReader;
import com.kumaran.tac.agent.config.FileBrowserConfig;
import com.kumaran.tac.agent.exceptions.FileAccessNotAllowedException;
import com.kumaran.tac.agent.service.FileBrowserService;
import com.kumaran.tac.common.dto.FileItemDto;
import com.kumaran.tac.common.dto.FileListResponseDto;
import com.kumaran.tac.common.dto.PreviewBlockDto;
import com.kumaran.tac.common.dto.PreviewResponseDto;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileBrowserService {
    private static final Logger ay = LoggerFactory.getLogger(FileBrowserService.class);
    @Autowired
    private FileBrowserConfig config;

    public FileListResponseDto listFiles(String string) throws IOException {
        String string2 = this.o(string);
        File file = new File(string2);
        if (!file.exists()) {
            throw new FileNotFoundException("Path does not exist: " + string);
        }
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Path is not a directory: " + string);
        }
        File[] fileArray = file.listFiles();
        ArrayList<FileItemDto> arrayList = new ArrayList<FileItemDto>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                try {
                    FileItemDto exception = this.b(file2);
                    arrayList.add(exception);
                }
                catch (Exception exception) {
                    ay.warn("Warning: Could not process file: " + file2.getName());
                }
            }
        }
        arrayList.sort((fileItemDto, fileItemDto2) -> {
            if (fileItemDto.getType().equals(fileItemDto2.getType())) {
                return fileItemDto.getName().compareToIgnoreCase(fileItemDto2.getName());
            }
            return fileItemDto.getType().equals("directory") ? -1 : 1;
        });
        String string3 = this.p(string2);
        return new FileListResponseDto(string2, string3, arrayList);
    }

    public PreviewResponseDto previewFile(String string, int n2) {
        try {
            PreviewResponseDto previewResponseDto;
            String string2;
            String string3;
            String string4 = this.o(string);
            File file = new File(string4);
            if (!file.exists() || !file.isFile()) {
                return this.v("File not found");
            }
            if (!file.canRead()) {
                return this.v("File not readable");
            }
            if (this.config.getMaxPreviewFileSizeMB() > 0L) {
                long l2 = this.config.getMaxPreviewFileSizeMB() * 1024L * 1024L;
                if (file.length() > l2) {
                    return this.v("File too large for preview");
                }
            }
            if (this.q(string3 = this.n(string2 = file.getName()).toLowerCase()) && (previewResponseDto = this.a(file, n2)).isSuccess()) {
                previewResponseDto.setFileName(string2);
                return previewResponseDto;
            }
            return this.a(file, string2, n2);
        }
        catch (FileAccessNotAllowedException fileAccessNotAllowedException) {
            return this.v("Access not allowed");
        }
        catch (Exception exception) {
            return this.v("Preview not available");
        }
    }

    private FileItemDto b(File file) throws IOException {
        Path path = file.toPath();
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        String string = file.getName();
        String string2 = file.isDirectory() ? "directory" : "file";
        String string3 = file.getCanonicalPath();
        long l2 = file.isFile() ? file.length() : 0L;
        Timestamp timestamp = new Timestamp(basicFileAttributes.lastModifiedTime().toMillis());
        String string4 = file.isFile() ? this.n(string) : null;
        boolean bl = file.isHidden();
        boolean bl2 = file.canRead();
        boolean bl3 = file.canWrite();
        String string5 = this.a(path);
        return new FileItemDto(string, string2, string3, l2, timestamp, string4, bl, bl2, bl3, string5, false);
    }

    private String n(String string) {
        int n2 = string.lastIndexOf(46);
        return n2 > 0 ? string.substring(n2 + 1) : "";
    }

    private String a(Path path) {
        try {
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
            return PosixFilePermissions.toString(set);
        }
        catch (Exception exception) {
            File file = path.toFile();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(file.canRead() ? "r" : "-");
            stringBuilder.append(file.canWrite() ? "w" : "-");
            stringBuilder.append(file.canExecute() ? "x" : "-");
            return stringBuilder.toString();
        }
    }

    private String o(String string) {
        if (string == null || string.trim().isEmpty()) {
            string = System.getProperty("user.dir");
        }
        if (string.matches("^[A-Za-z]:$")) {
            string = string + "\\";
        }
        try {
            if (!this.config.isAllowUpwardNavigation() && string.contains("..")) {
                throw new FileAccessNotAllowedException("Upward navigation not allowed");
            }
            File file = new File(string);
            String string2 = file.getCanonicalPath();
            if (this.config.isRestrictedMode() && !this.config.getAllowedPaths().isEmpty()) {
                boolean bl = false;
                for (String string3 : this.config.getAllowedPaths()) {
                    if (!string2.startsWith(string3)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new FileAccessNotAllowedException("Access to path not allowed");
                }
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new FileAccessNotAllowedException("Invalid path: " + string);
        }
    }

    private String p(String string) {
        try {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null && this.config.isAllowUpwardNavigation()) {
                if (this.config.isRestrictedMode() && !this.config.getAllowedPaths().isEmpty()) {
                    String string2 = file2.getCanonicalPath();
                    boolean bl = false;
                    for (String string3 : this.config.getAllowedPaths()) {
                        if (!string2.startsWith(string3)) continue;
                        bl = true;
                        break;
                    }
                    return bl ? string2 : null;
                }
                return file2.getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean q(String string) {
        return Arrays.asList("xls", "xlsx", "xlsm", "xlsb").contains(string);
    }

    private boolean r(String string) {
        return "xls".equals(string);
    }

    private boolean s(String string) {
        return Arrays.asList("xlsx", "xlsm", "xlsb").contains(string);
    }

    private PreviewResponseDto a(File file, int n2) {
        try {
            String string = file.getName();
            String string2 = this.n(string).toLowerCase();
            List list = new ArrayList();
            if (this.r(string2)) {
                list = this.b(file, n2);
            } else if (this.s(string2)) {
                list = this.c(file, n2);
            }
            if (list.isEmpty()) {
                return this.v("Excel preview not available");
            }
            PreviewResponseDto previewResponseDto = new PreviewResponseDto(true);
            previewResponseDto.setBlocks(list);
            return previewResponseDto;
        }
        catch (Exception exception) {
            return this.v("Excel preview not available: " + exception.getMessage());
        }
    }

    private List<PreviewBlockDto> b(File file, int n2) throws IOException {
        ArrayList<PreviewBlockDto> arrayList = new ArrayList<PreviewBlockDto>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);){
            for (int i2 = 0; i2 < hSSFWorkbook.getNumberOfSheets(); ++i2) {
                Sheet sheet = hSSFWorkbook.getSheetAt(i2);
                String string = sheet.getSheetName();
                if (string == null || string.trim().isEmpty()) {
                    string = "Sheet" + (i2 + 1);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(this.a(sheet));
                int n3 = 0;
                for (Row row : sheet) {
                    if (n3 >= n2) break;
                    ArrayList<Map> arrayList3 = new ArrayList<Map>();
                    for (Cell cell : row) {
                        Map map = this.a(cell);
                        arrayList3.add(map);
                    }
                    arrayList2.add(this.b(arrayList3));
                    ++n3;
                }
                arrayList.add(new PreviewBlockDto(string, arrayList2, "excel"));
            }
        }
        return arrayList;
    }

    private List<PreviewBlockDto> c(File file, int n2) throws IOException {
        ArrayList<PreviewBlockDto> arrayList = new ArrayList<PreviewBlockDto>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             Workbook workbook = StreamingReader.builder().rowCacheSize(100).bufferSize(4096).open((InputStream)fileInputStream);){
            for (int i2 = 0; i2 < workbook.getNumberOfSheets(); ++i2) {
                Sheet sheet = workbook.getSheetAt(i2);
                String string = sheet.getSheetName();
                if (string == null || string.trim().isEmpty()) {
                    string = "Sheet" + (i2 + 1);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(this.b(sheet));
                int n3 = 0;
                for (Row row : sheet) {
                    if (n3 >= n2) break;
                    ArrayList<Map> arrayList3 = new ArrayList<Map>();
                    for (Cell cell : row) {
                        Map map = this.a(cell);
                        arrayList3.add(map);
                    }
                    arrayList2.add(this.b(arrayList3));
                    ++n3;
                }
                arrayList.add(new PreviewBlockDto(string, arrayList2, "excel"));
            }
        }
        catch (Exception exception) {
            ay.error("Streaming reader failed, falling back to POI: " + exception.getMessage(), (Throwable)exception);
            try (FileInputStream fileInputStream2 = new FileInputStream(file);
                 XSSFWorkbook xSSFWorkbook = new XSSFWorkbook((InputStream)fileInputStream2);){
                for (int i3 = 0; i3 < xSSFWorkbook.getNumberOfSheets(); ++i3) {
                    Sheet sheet = xSSFWorkbook.getSheetAt(i3);
                    String string = sheet.getSheetName();
                    if (string == null || string.trim().isEmpty()) {
                        string = "Sheet" + (i3 + 1);
                    }
                    ArrayList<String> arrayList4 = new ArrayList<String>();
                    arrayList4.add(this.a(sheet));
                    int n4 = 0;
                    for (Row row : sheet) {
                        if (n4 >= n2) break;
                        ArrayList<Map> arrayList5 = new ArrayList<Map>();
                        for (Cell cell : row) {
                            Map map = this.a(cell);
                            arrayList5.add(map);
                        }
                        arrayList4.add(this.b(arrayList5));
                        ++n4;
                    }
                    arrayList.add(new PreviewBlockDto(string, arrayList4, "excel"));
                }
            }
        }
        return arrayList;
    }

    private String a(Sheet sheet) {
        ArrayList arrayList = new ArrayList();
        Row row = sheet.getRow(0);
        if (row != null) {
            for (int i2 = 0; i2 < row.getLastCellNum(); ++i2) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                int n2 = sheet.getColumnWidth(i2);
                int n3 = (int)((double)n2 / 256.0 * 7.0);
                n3 = Math.max(50, Math.min(n3, 300));
                hashMap.put("width", n3 + "px");
                arrayList.add(hashMap);
            }
        }
        if (arrayList.isEmpty()) {
            return "null";
        }
        return this.b(arrayList);
    }

    private String b(Sheet sheet) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Row row = null;
        Iterator iterator = sheet.iterator();
        if (iterator.hasNext()) {
            object = (Row)iterator.next();
            row = object;
        }
        if (row != null) {
            for (int i2 = 0; i2 < row.getLastCellNum(); ++i2) {
                object = new HashMap();
                object.put("width", "100px");
                arrayList.add(object);
            }
        }
        if (arrayList.isEmpty()) {
            return "null";
        }
        return this.b(arrayList);
    }

    private Map<String, String> a(Cell cell) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (cell == null) {
            hashMap.put("data", "");
            return hashMap;
        }
        String string = "";
        String string2 = "";
        switch (1.az[cell.getCellType().ordinal()]) {
            case 2: {
                string = string2 = cell.getStringCellValue();
                break;
            }
            case 1: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    DataFormatter dataFormatter = new DataFormatter();
                    string = dataFormatter.formatCellValue(cell);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                    String string3 = simpleDateFormat.format(date);
                    if (string3.endsWith(".000 ")) {
                        string3 = string3.replace(".000 ", " ");
                    }
                    if (string3.contains(" 00:00:00 ")) {
                        string3 = string3.replace(" 00:00:00 ", " ");
                    }
                    string2 = string3.trim();
                    break;
                }
                double d2 = cell.getNumericCellValue();
                DataFormatter dataFormatter = new DataFormatter();
                string = dataFormatter.formatCellValue(cell);
                if (!this.g(string, string2 = String.valueOf(d2))) break;
                string2 = string;
                break;
            }
            case 3: {
                boolean bl = cell.getBooleanCellValue();
                string = string2 = String.valueOf(bl).toUpperCase();
                break;
            }
            case 4: {
                try {
                    FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                    CellValue cellValue = formulaEvaluator.evaluate(cell);
                    switch (1.az[cellValue.getCellType().ordinal()]) {
                        case 1: {
                            double d3 = cellValue.getNumberValue();
                            string = String.valueOf(d3);
                            break;
                        }
                        case 2: {
                            string = cellValue.getStringValue();
                            break;
                        }
                        case 3: {
                            string = String.valueOf(cellValue.getBooleanValue()).toUpperCase();
                            break;
                        }
                        default: {
                            string = "";
                        }
                    }
                    string2 = cell.getCellFormula();
                }
                catch (Exception exception) {
                    string = "#ERROR";
                    string2 = cell.getCellFormula();
                }
                break;
            }
            default: {
                string2 = "";
                string = "";
            }
        }
        hashMap.put("data", string);
        if (!string.equals(string2) && !string.trim().isEmpty()) {
            hashMap.put("raw-data", string2);
        }
        return hashMap;
    }

    private boolean g(String string, String string2) {
        try {
            String string3 = string.replaceAll("[,\\s]", "");
            String string4 = string2.replaceAll("[,\\s]", "");
            double d2 = Double.parseDouble(string3);
            double d3 = Double.parseDouble(string4);
            return d2 == d3;
        }
        catch (NumberFormatException numberFormatException) {
            return string.trim().equals(string2.trim());
        }
    }

    private String b(List<Map<String, String>> list) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString(list);
        }
        catch (Exception exception) {
            return list.stream().map(map -> map.getOrDefault("data", "")).collect(Collectors.joining("\t"));
        }
    }

    private String b(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (1.az[cell.getCellType().ordinal()]) {
            case 2: {
                return cell.getStringCellValue();
            }
            case 1: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue().toString();
                }
                return String.valueOf(cell.getNumericCellValue());
            }
            case 3: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 4: {
                return cell.getCellFormula();
            }
        }
        return "";
    }

    private PreviewResponseDto a(File file, String string, int n2) {
        try {
            Object object;
            byte[] byArray = new byte[4];
            boolean bl = false;
            Charset charset = StandardCharsets.UTF_8;
            int n3 = 0;
            try (Object object2 = new FileInputStream(file);){
                int n4 = ((FileInputStream)object2).read(byArray);
                if (n4 > 0 && (bl = this.b((byte[])(object = Arrays.copyOf(byArray, n4))))) {
                    charset = this.c((byte[])object);
                    n3 = this.a((byte[])object);
                }
            }
            object2 = new ArrayList();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                if (n3 > 0) {
                    fileInputStream.skip(n3);
                }
                object = new InputStreamReader((InputStream)fileInputStream, charset);
                try (BufferedReader bufferedReader = new BufferedReader((Reader)object);){
                    String string2;
                    for (int i2 = 0; (string2 = bufferedReader.readLine()) != null && i2 < n2; ++i2) {
                        object2.add(this.u(string2));
                    }
                }
                finally {
                    ((InputStreamReader)object).close();
                }
            }
            fileInputStream = new PreviewBlockDto(null, (List)object2, "text");
            object = new PreviewResponseDto(true);
            object.setFileName(string);
            object.setBlocks(Arrays.asList(fileInputStream));
            object.setHasBOM(bl);
            object.setDetectedCharset(charset.name());
            return object;
        }
        catch (Exception exception) {
            return this.a(file, string);
        }
    }

    private int a(byte[] byArray) {
        if (byArray.length >= 4 && (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1 || byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0)) {
            return 4;
        }
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return 3;
        }
        if (byArray.length >= 2 && (byArray[0] == -1 && byArray[1] == -2 || byArray[0] == -2 && byArray[1] == -1)) {
            return 2;
        }
        return 0;
    }

    private boolean b(byte[] byArray) {
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return true;
        }
        if (byArray.length >= 2 && (byArray[0] == -1 && byArray[1] == -2 || byArray[0] == -2 && byArray[1] == -1)) {
            return true;
        }
        return byArray.length >= 4 && (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1 || byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0);
    }

    private Charset c(byte[] byArray) {
        if (byArray.length >= 4) {
            if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
                return Charset.forName("UTF-32LE");
            }
            if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
                return Charset.forName("UTF-32BE");
            }
        }
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return StandardCharsets.UTF_8;
        }
        if (byArray.length >= 2) {
            if (byArray[0] == -1 && byArray[1] == -2) {
                return StandardCharsets.UTF_16LE;
            }
            if (byArray[0] == -2 && byArray[1] == -1) {
                return StandardCharsets.UTF_16BE;
            }
        }
        return StandardCharsets.UTF_8;
    }

    private boolean t(String string) {
        return !string.contains("\ufffd");
    }

    private String u(String string) {
        if (string == null) {
            return "";
        }
        return string.replaceAll("[\\p{Cntrl}&&[^\t\n\r]]", "\ufffd");
    }

    private PreviewResponseDto a(File file, String string) {
        try {
            int n2;
            byte[] byArray = new byte[1000];
            try (Object object = new FileInputStream(file);){
                n2 = ((FileInputStream)object).read(byArray);
            }
            object = new String(byArray, 0, n2, StandardCharsets.UTF_8);
            object = this.u((String)object);
            PreviewResponseDto previewResponseDto = new PreviewResponseDto(false);
            previewResponseDto.setFileName(string);
            previewResponseDto.setError("Preview not available");
            previewResponseDto.setRawData((String)object);
            return previewResponseDto;
        }
        catch (Exception exception) {
            return this.v("Unable to read file");
        }
    }

    private PreviewResponseDto v(String string) {
        PreviewResponseDto previewResponseDto = new PreviewResponseDto(false);
        previewResponseDto.setError(string);
        return previewResponseDto;
    }
}

