/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kumaran.tac.agent.dto.UnregisterdAgentInfo;
import com.kumaran.tac.agent.model.Agent;
import com.kumaran.tac.agent.service.AgentRegistrationService;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.MasterAgentExecutor;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.common.dto.AgentRegistrationRequestDto;
import com.kumaran.tac.common.dto.AgentRegistrationResponseDto;
import com.kumaran.tac.common.enums.OperatingSystem;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.messages.MessageUtils;
import com.kumaran.tac.common.util.CommonUtility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.ModelAndView;

@Service
public class AgentRegistrationServiceImpl
implements AgentRegistrationService {
    private static final Logger A = LoggerFactory.getLogger(AgentRegistrationServiceImpl.class);
    @Autowired
    RestUtil restUtil;
    @Autowired
    MasterAgentExecutor masterAgentExecutor;

    public ModelAndView registerAgent(Agent agent, ModelAndView modelAndView) {
        Agent agent2 = new Agent();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String string = agent.getServerURL();
            String string2 = string + (string.endsWith("/") ? "" : "/") + "v1/registerAgent";
            AgentRegistrationRequestDto agentRegistrationRequestDto = new AgentRegistrationRequestDto();
            agentRegistrationRequestDto.setAgentName(agent.getAgentName());
            agentRegistrationRequestDto.setAgentURL(agent.getAgentURL());
            agentRegistrationRequestDto.setServerURL(string);
            agentRegistrationRequestDto.setOs(this.getOperatingSystem());
            agentRegistrationRequestDto.setTenantId(agent.getTenantId());
            AgentRegistrationResponseDto agentRegistrationResponseDto = (AgentRegistrationResponseDto)this.restUtil.postData(string2, (Object)agentRegistrationRequestDto, AgentRegistrationResponseDto.class);
            agent2.setAgentId(String.valueOf(agentRegistrationResponseDto.getAgentId()));
            agent2.setAgentName(agentRegistrationResponseDto.getMachineName());
            agent2.setAgentURL(agentRegistrationResponseDto.getAgentUrl());
            agent2.setServerURL(agentRegistrationResponseDto.getServerUrl());
            if (agentRegistrationResponseDto.getTenantId() != null && !agentRegistrationResponseDto.getTenantId().trim().isEmpty()) {
                agent2.setTenantId(agentRegistrationResponseDto.getTenantId());
            } else {
                agent2.setTenantId(agent.getTenantId());
                agentRegistrationResponseDto.setTenantId(agent.getTenantId());
            }
            agent2.setNewRegistration(agentRegistrationResponseDto.isNewRegistration());
            modelAndView.addObject("agent", (Object)agent2);
            Map map = CommonUtility.getPropertiesFromBean((Object)agentRegistrationResponseDto, String.class, null);
            if (map != null) {
                this.a(map);
                LoadConfigFile.writePropertyFile((Map)map);
            }
            LoadConfigFile.refresh();
            if (agent2.isNewRegistration()) {
                modelAndView.setViewName("registrationsuccess");
            } else {
                modelAndView.setViewName("alreadyregistered");
            }
            new Thread((Runnable)this.masterAgentExecutor).start();
        }
        catch (Exception exception) {
            A.error("Inside AgentController.saveAgentDetail()", (Throwable)exception);
            modelAndView.setViewName(MessageUtils.getMessage((String)"ERROR").toLowerCase());
        }
        return modelAndView;
    }

    private void a(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<String> list = Arrays.asList("agentId", "agentUrl", "serverUrl", "machineName", "tenantId");
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!list.contains(entry.getKey())) continue;
                hashMap.put("agent".concat(".").concat(entry.getKey()), entry.getValue());
            }
            map.clear();
            map.putAll(hashMap);
        }
    }

    private OperatingSystem getOperatingSystem() {
        return CommonUtility.getOperatingSystem();
    }

    public UnregisterdAgentInfo unregisterAgent() {
        UnregisterdAgentInfo unregisterdAgentInfo = new UnregisterdAgentInfo();
        try {
            LoadConfigFile loadConfigFile = LoadConfigFile.getInstance();
            unregisterdAgentInfo.setServerUrl(loadConfigFile.getPropertyAsString("agent.serverUrl"));
            unregisterdAgentInfo.setAgentId(loadConfigFile.getPropertyAsIntger("agent.agentId"));
            unregisterdAgentInfo.setTenantId(loadConfigFile.getPropertyAsString("agent.tenantId"));
            unregisterdAgentInfo.setUnregisterStatus(true);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("agent.serverUrl", null);
            hashMap.put("agent.agentId", null);
            hashMap.put("agent.tenantId", null);
            LoadConfigFile.writePropertyFile(hashMap);
        }
        catch (Exception exception) {
            CommonUtility.exceptionMessageLogger((String)"Inside AgentRegistrationServiceImpl.unregisterAgent()", (Throwable)exception);
            throw new TACException(MessageUtils.getMessage((String)"AGENT.UNREGISTRATION_FAILED"));
        }
        A.debug("Inside AgentRegistrationServiceImpl.unregisterAgent() - unregisterdAgentInfo: {}", (Object)unregisterdAgentInfo);
        return unregisterdAgentInfo;
    }

    public void unregisterConfirmation(String string, UnregisterdAgentInfo unregisterdAgentInfo) {
        String string2 = "unregisterAgentConfirmation/" + unregisterdAgentInfo.getAgentId() + "/" + unregisterdAgentInfo.isUnregisterStatus();
        A.info("Request to URL: {}", (Object)string2);
        String string3 = (String)this.restUtil.getData(string2, String.class);
        A.info("Response: {}", (Object)string3);
        MasterAgentExecutor.setServerUrlExists((boolean)false);
        LoadConfigFile.refresh();
    }
}

