/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.RemoteFileDownloader;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.agent.util.TestRunLogger;
import com.kumaran.tac.common.dto.AgentContext;
import com.kumaran.tac.common.dto.UploadFileExecutionDTO;
import com.kumaran.tac.common.dto.ValidationModel;
import com.kumaran.tac.common.enums.ValidationStatus;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.util.AgentCommonUtil;
import com.kumaran.tac.common.util.EncryptUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.jexl3.JexlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AgentCommonImpl
implements AgentCommonUtil {
    private static final Logger y = LoggerFactory.getLogger(AgentCommonImpl.class);
    @Autowired
    RestUtil restUtil;
    @Autowired
    ApplicationContext context;
    @Autowired
    AgentService agentService;

    public <T> String performHttpTrigger(String string, Object object, Class<T> clazz, Map<String, Object> map) {
        Object object2 = this.restUtil.postData(string, object, clazz, map);
        return object2.toString();
    }

    public <T> String performHttpTriggers(String string, Class<String> clazz, Map<String, Object> map) {
        String string2 = (String)this.restUtil.getData(string, clazz, map);
        return string2;
    }

    public Map<String, Object> parentParameterValue() {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        Map map = testRunExecutionData.getValidationData();
        Map<String, Object> map2 = new HashMap<String, Object>();
        if (map != null && map.containsKey("variables") && map.get("variables") != null) {
            map2 = (Map)map.get("variables");
        }
        return map2;
    }

    public Map<String, String> updateResultParameterValue(String string, String string2) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string, string2);
        this.updateLatestVariables(hashMap);
        Map map = EncryptUtil.getMaskedVariablesMapWithNewCopy(hashMap);
        y.info("Updated variables is : {}", (Object)map);
        Map map2 = testRunExecutionData.getValidationData();
        Map<String, String> map3 = new HashMap<String, String>();
        if (map2 != null && map2.containsKey("variables") && map2.get("variables") != null) {
            map3 = (Map)map2.get("variables");
            try {
                map3.put(string, string2);
                Map map4 = EncryptUtil.getMaskedVariablesMapWithNewCopy(new HashMap<String, String>(map3));
                y.info("Latest Variables is : {}", (Object)map4);
            }
            catch (Exception exception) {
                y.info("Error occurred while setting values for variables", (Throwable)exception);
            }
        }
        return map3;
    }

    public void fileDownloadforAction(List<UploadFileExecutionDTO> list, String string) {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        ExecutorService executorService = Executors.newFixedThreadPool(list.size());
        ArrayList arrayList = new ArrayList();
        try {
            File file;
            if (string == null || string.isEmpty()) {
                string = System.getProperty("java.io.tmpdir");
            }
            if (!(file = new File(string)).exists()) {
                file.mkdirs();
            }
            for (UploadFileExecutionDTO object : list) {
                RemoteFileDownloader remoteFileDownloader = (RemoteFileDownloader)this.context.getBean(RemoteFileDownloader.class);
                remoteFileDownloader.setFilePath(file.getAbsolutePath());
                remoteFileDownloader.setFileId(object.getFileId());
                remoteFileDownloader.setFileName(object.getFileName());
                remoteFileDownloader.setCompressed(object.isExtractInd());
                remoteFileDownloader.setTestRunExecutionId(testRunExecutionData.getTestRunExecutionId());
                remoteFileDownloader.setAgentId(LoadConfigFile.getAgentId());
                arrayList.add(executorService.submit((Runnable)remoteFileDownloader));
            }
            if (!arrayList.isEmpty()) {
                for (Future future : arrayList) {
                    future.get();
                }
            }
        }
        catch (Exception exception) {
            throw new TACException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            executorService.shutdown();
        }
    }

    public Map<Integer, Object> getUploadedFilesIdFromTAC(String string, Object object, Class<String> clazz, Map<String, Object> map) {
        String string2 = (String)this.restUtil.postData(string, object, clazz, map);
        org.jcodec.common.logging.Logger.info((String)"file details is : {}", (Object[])new Object[]{string2});
        ObjectMapper objectMapper = new ObjectMapper();
        Map<Integer, Object> map2 = new HashMap<Integer, Object>();
        try {
            map2 = (Map)objectMapper.readValue(string2, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonMappingException jsonMappingException) {
            y.info("Error caused due to : {}", (Throwable)jsonMappingException);
        }
        catch (JsonProcessingException jsonProcessingException) {
            y.info("Error caused due to : {}", (Throwable)jsonProcessingException);
        }
        return map2;
    }

    public String getEvaluateExpression(String string) {
        String string2 = this.agentService.evaluateExpression(string);
        return string2;
    }

    public String getEvaluateExpression(String string, Map<String, String> map) {
        String string2 = this.agentService.evaluateExpression(string, map);
        return string2;
    }

    public void sendEmailForAction(String string, ValidationModel validationModel, int n2, ValidationStatus validationStatus) {
        this.agentService.emailActionStarted(string, validationModel, n2, validationStatus);
    }

    public void sendEmailForAction(String string, ValidationModel validationModel, int n2, ValidationStatus validationStatus, String string2) {
        this.agentService.emailActionStarted(string, validationModel, n2, validationStatus, string2);
    }

    public int getTestrunExecutionId() {
        TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
        return testRunExecutionData.getTestRunExecutionId();
    }

    public void updateLatestVariables(Map<String, Object> map) {
        this.agentService.updateVariableDetail(map, null);
    }

    public File getDefaultDirectory() {
        return TestRunLogger.getTestRunLogger((Integer)this.getTestrunExecutionId(), (String)LoadConfigFile.getAgentId()).getLogFolder();
    }

    public JexlEngine getAgentJexlEngine(AgentContext agentContext) {
        return this.agentService.getAgentJexlEngine(agentContext);
    }

    public Map<String, Object> getVariableDetailValues() {
        return this.agentService.getVariableDetailValues();
    }

    public String getExpressionValueOfExpression(String string) {
        return this.agentService.getExpressionValueOfExpression(string);
    }
}

