/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.controller;

import com.kumaran.tac.agent.exceptions.FileAccessNotAllowedException;
import com.kumaran.tac.agent.exceptions.FileNotFoundException;
import com.kumaran.tac.agent.service.FileBrowserService;
import com.kumaran.tac.common.dto.FileListResponseDto;
import com.kumaran.tac.common.dto.PreviewResponseDto;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/files"})
@CrossOrigin(origins={"*"})
public class FileController {
    @Autowired
    private FileBrowserService fileBrowserService;

    @GetMapping
    public ResponseEntity<FileListResponseDto> listFiles(@RequestParam(required=false) String string) {
        try {
            FileListResponseDto fileListResponseDto = this.fileBrowserService.listFiles(string);
            return ResponseEntity.ok((Object)fileListResponseDto);
        }
        catch (FileAccessNotAllowedException fileAccessNotAllowedException) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
        }
        catch (IOException iOException) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/preview"})
    public ResponseEntity<PreviewResponseDto> previewFile(@RequestParam String string, @RequestParam(defaultValue="20") int n2) {
        try {
            PreviewResponseDto previewResponseDto = this.fileBrowserService.previewFile(string, n2);
            return ResponseEntity.ok((Object)previewResponseDto);
        }
        catch (FileAccessNotAllowedException fileAccessNotAllowedException) {
            PreviewResponseDto previewResponseDto = new PreviewResponseDto(false);
            previewResponseDto.setError("Access not allowed");
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)previewResponseDto);
        }
        catch (Exception exception) {
            PreviewResponseDto previewResponseDto = new PreviewResponseDto(false);
            previewResponseDto.setError("Unexpected error occurred");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)previewResponseDto);
        }
    }
}

