/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.AgentExecutor;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.MasterAgentExecutor;
import com.kumaran.tac.agent.util.ScreenVideoUtil;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.common.dto.AgentCommand;
import com.kumaran.tac.common.dto.ApiResponseDTO;
import com.kumaran.tac.common.dto.AttributeStatusDTO;
import com.kumaran.tac.common.dto.DownloadMonitor;
import com.kumaran.tac.common.dto.ErrorValidationsResponse;
import com.kumaran.tac.common.dto.FailureDetail;
import com.kumaran.tac.common.dto.FileDownloadResponseDTO;
import com.kumaran.tac.common.dto.FrameworkDataResponse;
import com.kumaran.tac.common.dto.FrameworkUploadFileDTO;
import com.kumaran.tac.common.dto.FrameworkValidationEntity;
import com.kumaran.tac.common.dto.ManualInputDTO;
import com.kumaran.tac.common.dto.ManualInputField;
import com.kumaran.tac.common.dto.RunDetailHeadersDTO;
import com.kumaran.tac.common.dto.StandardErrorInfo;
import com.kumaran.tac.common.dto.StatsDTO;
import com.kumaran.tac.common.dto.TestStep;
import com.kumaran.tac.common.dto.TestStepData;
import com.kumaran.tac.common.enums.ActionOnValidationFailure;
import com.kumaran.tac.common.enums.AgentCommandMessage;
import com.kumaran.tac.common.enums.AgentTestRunExecutionPhase;
import com.kumaran.tac.common.enums.FrameworkEnum;
import com.kumaran.tac.common.enums.TestStepStatus;
import com.kumaran.tac.common.exception.TACException;
import com.kumaran.tac.common.util.CommonUtility;
import com.kumaran.tac.common.util.EncryptUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/agent/v1/agents/{agentId}/tre/{testRunExecutionId}"})
public class AgentTestRunController {
    private static final Logger logger = LoggerFactory.getLogger(AgentTestRunController.class);
    public static final String home = CommonUtility.getBaseDir();
    private static AgentCommand waitCommand = new AgentCommand(AgentCommandMessage.Wait);
    @Autowired
    private AgentService agentService;
    @Autowired
    ScreenVideoUtil screenVideoUtil;

    @GetMapping(value={"/screenshot/{type}/{reference}"})
    public ResponseEntity<String> saveScreenshot(@PathVariable(value="testRunExecutionId") Integer n2, @PathVariable(value="type") String string, @PathVariable(value="reference") String string2) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
            boolean bl = testRunExecutionData.isSensitiveTransaction();
            this.agentService.getScreenshot(n2, string + "-" + string2, bl, null);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)"success"), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/saveTestStepResult"}, consumes={"application/json"})
    public ResponseEntity<String> saveTransactionStep(@RequestBody Map<String, Object> map, @PathVariable(value="agentId") String string) {
        try {
            Object object;
            ObjectMapper objectMapper = new ObjectMapper();
            if (map.containsKey("startTime")) {
                logger.debug("Start Time (String): {}", (Object)((String)map.get("startTime")));
                object = Timestamp.valueOf((String)map.get("startTime"));
                logger.debug("Start Time (Timestamp): {}", object);
                map.put("startTime", object);
            }
            if (map.containsKey("completedTime")) {
                logger.debug("Completed Time (String): {}", (Object)((String)map.get("completedTime")));
                object = Timestamp.valueOf((String)map.get("completedTime"));
                logger.debug("Completed Time (Timestamp): {}", object);
                map.put("completedTime", object);
            }
            object = TestStepStatus.get((String)((String)map.get("status")));
            TestRunExecutionData testRunExecutionData = TestRunExecutionData.getTestRunExecutionData();
            testRunExecutionData.setLastStepStatus(object);
            Object object2 = map.get("testRunExecutionId");
            Integer n2 = 0;
            if (object2 instanceof String) {
                n2 = Integer.parseInt((String)object2);
            } else if (object2 instanceof Number) {
                n2 = (Integer)object2;
            }
            String string2 = CommonUtility.getAsString((Object)map.get("testRunStepId"));
            if (TestStepStatus.FAIL.equals(object)) {
                String string3 = (String)map.get("screenshotFile");
                boolean bl = testRunExecutionData.isSensitiveTransaction();
                this.agentService.getScreenshot(n2, "Step-" + string2, bl, string3);
            } else if (TestStepStatus.ABORTED.equals(object)) {
                String string4 = objectMapper.writeValueAsString(map.get("failureReason"));
                FailureDetail failureDetail = (FailureDetail)objectMapper.readValue(string4, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                String string5 = CommonUtility.getAsString((Object)failureDetail.getMessage());
                this.agentService.abortTestRun(string5, string);
            } else if (TestStepStatus.PASS.equals(object)) {
                map.put("failureReason", null);
            }
            this.agentService.saveTestStepResult(map);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)"success"), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/saveDataResult"}, consumes={"application/json"})
    public ResponseEntity<String> saveDqvResult(@RequestBody List<FrameworkDataResponse> list) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.agentService.saveDataResult(list);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)"Success"), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.info("Exception occurred while sending data to agent");
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/agentValidation"}, produces={"application/json"})
    public ResponseEntity<String> agentValidation(@RequestBody FrameworkValidationEntity frameworkValidationEntity) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            FrameworkValidationEntity frameworkValidationEntity2 = this.agentService.getValidationStatus(frameworkValidationEntity, null);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)frameworkValidationEntity2), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/standardValidations/{attributeId}"}, produces={"application/json"})
    public ResponseEntity<String> performStandardValidations(@RequestBody StandardErrorInfo standardErrorInfo, @PathVariable(value="attributeId") String string, @RequestParam(name="dialog", required=false) boolean bl) {
        try {
            logger.info("Request recieved for standardValidations: {} and dialog flag is :{}", (Object)standardErrorInfo, (Object)bl);
            ObjectMapper objectMapper = new ObjectMapper();
            ErrorValidationsResponse errorValidationsResponse = this.agentService.performStandardValidations(standardErrorInfo, Integer.parseInt(string), bl);
            logger.info("Response for standardValidations call: {}", (Object)errorValidationsResponse);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)errorValidationsResponse), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/saveResponseData"}, produces={"application/json"})
    public ResponseEntity<String> saveResponseData(@RequestBody ApiResponseDTO apiResponseDTO) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.agentService.saveResponseData(apiResponseDTO);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)"success"), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/nextStep/{frameworkName}"}, produces={"application/json"})
    public ResponseEntity<String> getNextStep(@PathVariable(value="frameworkName") String string, @PathVariable(value="agentId") String string2, @RequestParam(name="action", required=false) String string3) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        AgentExecutor agentExecutor = MasterAgentExecutor.getAgentExecutor((String)string2);
        if (agentExecutor != null) {
            agentExecutor.addMessageToServerCallQueue("nextStepData", string2);
        }
        AgentCommand agentCommand = null;
        this.screenVideoUtil.stopRecording();
        try {
            JSONObject jSONObject;
            JSONParser jSONParser;
            ObjectMapper objectMapper2;
            String string4;
            AgentCommand agentCommand2 = null;
            if (string != null && string.endsWith("-testRunComplete") || string3 != null && string3.equals("testRunComplete")) {
                this.agentService.clearTranslation();
                return null;
            }
            agentCommand2 = this.agentService.getNextStepDataFromQueue(string, string2);
            if (agentCommand2 == null) {
                agentCommand = waitCommand;
                return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)agentCommand), HttpStatus.OK);
            }
            if (agentCommand2.getPhase() == AgentTestRunExecutionPhase.TestRunAborted) {
                this.agentService.clearTranslation();
                return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)agentCommand2), HttpStatus.OK);
            }
            if (AgentCommandMessage.SwitchTo.equals((Object)agentCommand2.getMsg())) {
                return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)agentCommand2), HttpStatus.OK);
            }
            TestStep testStep = agentCommand2.getDataAsTestStep();
            if (agentCommand2.getData() != null) {
                if (agentCommand2.getData().containsKey("teststepData")) {
                    string4 = agentCommand2.getData().get("teststepData");
                    objectMapper2 = new ObjectMapper();
                    jSONParser = new JSONParser();
                    jSONObject = (JSONObject)jSONParser.parse(objectMapper2.writeValueAsString((Object)string4));
                    hashMap.put("testDataGroupId", CommonUtility.getAsString((Object)jSONObject.get((Object)"testDataGroupId")));
                    hashMap.put("testRunStepId", CommonUtility.getAsString((Object)jSONObject.get((Object)"testRunStepId")));
                    hashMap.put("testRunExecutionId", TestRunExecutionData.getCurrentTestRunExecutionId());
                    hashMap.put("status", TestStepStatus.ERROR.getStatus());
                }
                if (testStep.getProjectCode() != null) {
                    this.agentService.setCurrentProjectCode(testStep.getProjectCode());
                } else if (testStep.getExecutionPlan() != null) {
                    this.agentService.setCurrentProjectCode(testStep.getExecutionPlan().getProjectCode());
                }
            }
            this.agentService.getLatestVariables(agentCommand2);
            string4 = agentCommand2.getTool();
            logger.info("Retrieve data From : {} and  queue: {}", (Object)string, (Object)agentCommand2);
            objectMapper2 = FrameworkEnum.getFrameworkEnum((String)string4);
            if (agentCommand2.getData() != null && !FrameworkEnum.DATA.equals((Object)objectMapper2)) {
                this.agentService.formValidationJson(agentCommand2);
                jSONParser = testStep.getExecutionPlan();
                this.agentService.setCurrentProjectCode(jSONParser.getProjectCode());
                if (objectMapper2 == null) {
                    objectMapper2 = FrameworkEnum.getFrameworkEnum((String)jSONParser.getTool());
                }
                if (objectMapper2 != null && objectMapper2.isSupportsScreenRecording()) {
                    TestStepData testStepData;
                    jSONObject = new ScreenVideoUtil.ScreenRecorderConfig();
                    Boolean bl = jSONParser.getRecordExecution();
                    if (bl == null) {
                        bl = false;
                    }
                    Boolean bl2 = jSONParser.getRecordFailureOnly();
                    jSONObject.setExecutionPlanRecordOnlyFailed(bl2.booleanValue());
                    if (bl2 == null) {
                        bl2 = true;
                    }
                    jSONObject.setTestRunRecordExecution(bl.booleanValue());
                    jSONObject.setTestRunRecordFailureOnly(bl2);
                    boolean bl3 = LoadConfigFile.getInstance().getPropertyAsBoolean("localRecording.enable", Boolean.valueOf(false));
                    boolean bl4 = LoadConfigFile.getInstance().getPropertyAsBoolean("localRecording.failureOnly", Boolean.valueOf(true));
                    boolean bl5 = LoadConfigFile.getInstance().getPropertyAsBoolean("recording.retain", Boolean.valueOf(bl3));
                    jSONObject.setLocalRecordExecution(bl3);
                    jSONObject.setLocalRecordFailureOnly(bl4);
                    jSONObject.setLocalRetainRecording(bl5);
                    Integer n2 = (int)jSONParser.getType();
                    if (jSONObject.getRecordExecution() && (n2 != null && n2 == 1 || objectMapper2 != null && objectMapper2.isSupportsScreenRecording()) && (testStepData = testStep.getTeststepData()) != null && testStepData.getTestRunStepId() != null) {
                        Integer n3 = testStepData.getTestRunStepId();
                        jSONObject.setTestRunDetailId(Integer.valueOf(n3));
                        jSONObject.setTestRunExecutionId(Integer.valueOf(TestRunExecutionData.getCurrentTestRunExecutionId()));
                        this.screenVideoUtil.startRecording((ScreenVideoUtil.ScreenRecorderConfig)jSONObject);
                    }
                }
            }
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)agentCommand2), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            if (exception instanceof TACException) {
                FailureDetail failureDetail = new FailureDetail();
                failureDetail.setStepId(Integer.valueOf(CommonUtility.getInt(hashMap.get("testRunStepId"))));
                failureDetail.setMessage((Object)exception.getMessage());
                failureDetail.setMessageCode(" ");
                hashMap.put("failureReason", failureDetail);
                this.agentService.saveTestStepResult(hashMap);
            }
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/expressionValue"})
    public ResponseEntity<String> getExpressionValue(@RequestBody Map<String, String> map) throws JsonProcessingException {
        Map map2 = this.agentService.getExpressionValue(map);
        logger.info("Expression Output: {}", (Object)EncryptUtil.maskExpressionOutput((Map)map2));
        return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)map2), HttpStatus.OK);
    }

    @GetMapping(value={"/getVariableDetails"})
    public ResponseEntity<String> getVariableDetails() throws JsonProcessingException {
        Map map = this.agentService.getVariableDetailValues();
        if (logger.isInfoEnabled()) {
            logger.info("Variable Details: {}", (Object)EncryptUtil.getMaskedVariablesMapWithNewCopy((Map)map));
        }
        return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)map), HttpStatus.OK);
    }

    @PostMapping(value={"/setExpressionValue/{iterator}"})
    public ResponseEntity<String> setExpressionValue(@RequestBody Map<String, String> map, @PathVariable(value="iterator") int n2) throws JsonProcessingException {
        String string = this.agentService.setExpressionValue(map, n2);
        logger.info("Expression Output: {}", (Object)string);
        return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)string), HttpStatus.OK);
    }

    @GetMapping(value={"/configExpressions/{browserOptionFile}"}, produces={"application/json"})
    public ResponseEntity<String> updateConfigExpressions(@PathVariable String string) throws JsonProcessingException {
        String string2 = this.agentService.setConfigExpressions(string, TestRunExecutionData.getCurrentTestRunExecutionId());
        return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)string2), HttpStatus.OK);
    }

    @PostMapping(value={"/project/{projectId}/transaction/{transactionId}/translateValues"})
    public ResponseEntity<String> getTranslatedValues(@RequestBody List<String> list, @PathVariable(value="projectId") String string, @PathVariable(value="transactionId") String string2) throws JsonProcessingException {
        Map map = this.agentService.getTranslatedValues(list, string, string2);
        logger.info("Translation Output: {}", (Object)map);
        return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)map), HttpStatus.OK);
    }

    @PostMapping(value={"/updateVariableValue"})
    public ResponseEntity<String> updateVariableValue(@RequestBody Map<String, String> map) {
        try {
            for (String string : map.keySet()) {
                logger.info("variable is: {}, value is : {}", (Object)string, (Object)map.get(string));
                this.agentService.updateVariableDetail(string, (Object)map.get(string), null);
            }
            return new ResponseEntity((Object)"success", HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/framework/{frameworkName}/waitOnDebug"})
    public ResponseEntity<String> waitOnDebug(@PathVariable(value="frameworkName") String string, @PathVariable(value="agentId") String string2) {
        try {
            this.agentService.waitOnDebug(string, string2);
            return new ResponseEntity((Object)"success", HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/nextActionAfterValidation"})
    public ResponseEntity<String> getNextActionAfterValidation() {
        try {
            ActionOnValidationFailure actionOnValidationFailure = this.agentService.getOverAllValidationStatus();
            if (actionOnValidationFailure != ActionOnValidationFailure.DO_NOT_FAIL_TESTCASE) {
                this.agentService.resetValidationRetryData();
            }
            return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)actionOnValidationFailure), HttpStatus.OK);
        }
        catch (Exception exception) {
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/resetValidationRetryData"})
    public ResponseEntity<String> resetValidationRetryData() {
        try {
            this.agentService.resetValidationRetryData(true);
            return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)"success"), HttpStatus.OK);
        }
        catch (Exception exception) {
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/attributeStatus/{testRunDetailId}"})
    public ResponseEntity<String> getAttributeStatus(@RequestBody AttributeStatusDTO attributeStatusDTO, @PathVariable(value="testRunDetailId") Integer n2) {
        try {
            logger.info("frameworkName : {}", (Object)attributeStatusDTO);
            String string = this.agentService.addAttributeStatus(attributeStatusDTO, n2);
            return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)string), HttpStatus.OK);
        }
        catch (Exception exception) {
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/framework/{frameworkName}/monitorDownload"})
    public ResponseEntity<FileDownloadResponseDTO> monitorDownload(@PathVariable(value="frameworkName") String string, @RequestBody DownloadMonitor downloadMonitor) {
        try {
            logger.info("monitorDownload request received: {}", (Object)downloadMonitor);
            logger.info("frameworkName : {}", (Object)string);
            FileDownloadResponseDTO fileDownloadResponseDTO = this.agentService.monitorDownload(downloadMonitor, string);
            return new ResponseEntity((Object)fileDownloadResponseDTO, HttpStatus.OK);
        }
        catch (Exception exception) {
            FileDownloadResponseDTO fileDownloadResponseDTO = new FileDownloadResponseDTO();
            fileDownloadResponseDTO.setMessageCode("Error occurred.");
            fileDownloadResponseDTO.setFailureReason(exception.toString());
            return new ResponseEntity((Object)fileDownloadResponseDTO, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/stats/update"}, consumes={"application/json"})
    public ResponseEntity<String> updateStats(@RequestBody Map<String, StatsDTO> map) {
        try {
            long l2 = System.currentTimeMillis();
            logger.info("Update stats request : {}", map);
            String string = this.agentService.updateStats(map);
            logger.info("Time taken to update stats : {} ms", (Object)(System.currentTimeMillis() - l2));
            return ResponseEntity.ok((Object)string);
        }
        catch (Exception exception) {
            return ResponseEntity.internalServerError().body((Object)exception.getMessage());
        }
    }

    @PostMapping(value={"evaluateCondition"})
    public ResponseEntity<String> evaluateCondition(@RequestBody FrameworkValidationEntity frameworkValidationEntity) throws JsonProcessingException {
        logger.info("Evaluate condition request : {}", (Object)frameworkValidationEntity);
        String string = this.agentService.evaluateValidationCondition(frameworkValidationEntity);
        return new ResponseEntity((Object)new ObjectMapper().writeValueAsString((Object)string), HttpStatus.OK);
    }

    @PostMapping(value={"remoteFiles"})
    public ResponseEntity<FrameworkUploadFileDTO> getRemoteFiles(@RequestBody List<Integer> list) {
        logger.info("Requesting remote files for ids : {}", list);
        FrameworkUploadFileDTO frameworkUploadFileDTO = this.agentService.getUploadFilePath(list);
        logger.info("Remote file response for ids : {} is {}", list, (Object)frameworkUploadFileDTO);
        return new ResponseEntity((Object)frameworkUploadFileDTO, HttpStatus.OK);
    }

    @GetMapping(value={"checkIfManualInputRequired"})
    public ResponseEntity<ManualInputDTO> checkIfManualInputRequired() {
        logger.debug("Checking if Manual Input required");
        ManualInputDTO manualInputDTO = this.agentService.checkIfManualInputRequired();
        logger.debug("Response for checking manual input : {}", (Object)manualInputDTO);
        return ResponseEntity.ok((Object)manualInputDTO);
    }

    @PostMapping(value={"blockUntilManualInput"})
    public ResponseEntity<String> blockUntilManualInput(@RequestBody List<ManualInputField> list) {
        logger.debug("Blocking until manual input with data : {}", list);
        String string = this.agentService.blockUntilManualInput(list);
        logger.info("Response for manual input : {}", (Object)string);
        return ResponseEntity.ok((Object)string);
    }

    @PostMapping(value={"getTriggerActionStatus"})
    public ResponseEntity<String> getTriggerActionStatus(@RequestBody FrameworkValidationEntity frameworkValidationEntity) {
        logger.debug("Request for trigger action status : {}", (Object)frameworkValidationEntity);
        String string = this.agentService.getTriggerActionStatus(frameworkValidationEntity);
        logger.info("Response for trigger action status: {}", (Object)string);
        return ResponseEntity.ok((Object)string);
    }

    @PostMapping(value={"/runDetailId/{runDetailId}/type/{type}/saveHeaders"}, consumes={"application/json"})
    public ResponseEntity<String> sendHeaders(@PathVariable(value="runDetailId") int n2, @PathVariable(value="type") String string, @RequestBody List<RunDetailHeadersDTO> list) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.agentService.sendResultHeaders(list, n2, string);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)"success"), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/sendSummaryResult"}, consumes={"application/json"})
    public ResponseEntity<String> sendSummaryResult(@RequestBody List<FrameworkDataResponse> list, @PathVariable(value="testRunExecutionId") Integer n2) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            this.agentService.sendSummaryResult(list, n2);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)"success"), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.info("Exception occurred while sending data to agent");
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/logs"}, consumes={"application/json"})
    public void receiveLog(@RequestBody Map<String, Object> map) throws JsonProcessingException {
        System.out.println("Received log: " + new ObjectMapper().writeValueAsString(map));
    }

    @PostMapping(value={"/saveDataResults"}, consumes={"application/json"})
    public ResponseEntity<String> saveDataResult(@RequestBody Map<String, Object> map) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String string = (String)map.get("data");
            Integer n2 = (Integer)map.get("runDetailId");
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            this.agentService.saveDataResultToServer(bufferedReader, n2);
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)"success"), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing data", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

