/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kumaran.tac.agent.AgentApplication;
import com.kumaran.tac.agent.model.Agent;
import com.kumaran.tac.agent.service.AgentRegistrationService;
import com.kumaran.tac.agent.service.AgentService;
import com.kumaran.tac.agent.util.BuildVersion;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.agent.util.SupportProcesses;
import com.kumaran.tac.agent.util.TestRunExecutionData;
import com.kumaran.tac.common.enums.Browser;
import com.kumaran.tac.common.util.CommonUtility;
import com.kumaran.tac.common.windows.WindowsBrowserUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RestController
@CrossOrigin
@RequestMapping(value={"/agent/v1/agents/{agentId}"})
public class AgentController {
    private static final Logger logger = LoggerFactory.getLogger(AgentController.class);
    public static final String home = CommonUtility.getBaseDir();
    @Autowired
    private AgentService agentService;
    @Autowired
    private AgentRegistrationService agentRegistrationService;
    @Autowired
    private ServletWebServerApplicationContext webServerAppCtxt;
    @Value(value="${server.ssl.enabled}")
    private boolean isSslEnabled;

    @RequestMapping(value={"/uploadFramework"}, method={RequestMethod.POST})
    public int frameworkUpload(@RequestParam(value="file") MultipartFile multipartFile) {
        int n2 = this.agentService.frameworkUpload(multipartFile);
        return n2;
    }

    @RequestMapping(value={"/checkHealth"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<String> checkHealth() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String string = "success";
            return new ResponseEntity((Object)objectMapper.writeValueAsString((Object)string), HttpStatus.OK);
        }
        catch (Exception exception) {
            logger.error("Error in processing.", (Throwable)exception);
            return new ResponseEntity((Object)exception.toString(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/agentRegistration"})
    public ModelAndView registration(ModelAndView modelAndView, Agent agent, @PathVariable(value="agentId") String string) {
        if (string != null) {
            agent.setAgentId("" + string);
            agent.setAgentName(LoadConfigFile.getInstance().getPropertyAsString("agent.machineName"));
            agent.setAgentURL(LoadConfigFile.getInstance().getPropertyAsString("agent.agentUrl"));
            agent.setServerURL(LoadConfigFile.getInstance().getServerUrl());
            agent.setTenantId(LoadConfigFile.getInstance().getPropertyAsString("agent.tenantId"));
            modelAndView.setViewName("alreadyregistered");
        } else {
            int n2 = this.webServerAppCtxt.getWebServer().getPort();
            try {
                String[] stringArray = this.getMachineNameAndIP();
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                if (string2 != null) {
                    string2 = string2 + "-" + System.getProperty("user.name");
                    agent.setAgentName(string2);
                }
                if (string3 != null) {
                    String string4 = (this.isSslEnabled ? "https://" : "http://") + string3 + ":" + n2;
                    agent.setAgentURL(string4);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            modelAndView.setViewName("registration");
        }
        modelAndView.addObject("agent", (Object)agent);
        modelAndView.addObject("agentId", (Object)string);
        return modelAndView;
    }

    private String[] getMachineNameAndIP() throws Exception {
        String[] stringArray = new String[2];
        String string = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = System.getenv("COMPUTERNAME");
        }
        if (string2 == null) {
            string2 = System.getenv("HOSTNAME");
        }
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        block2: for (NetworkInterface networkInterface : Collections.list(enumeration)) {
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                logger.info("InetAddress: %s, %s, %s, loopback? {}", new Object[]{inetAddress.getHostAddress(), inetAddress.getHostName(), inetAddress.getCanonicalHostName(), inetAddress.isLoopbackAddress()});
                if (inetAddress.isLoopbackAddress() || "127.0.0.1".equals(inetAddress.getHostAddress())) continue;
                if (string2 == null) {
                    string2 = inetAddress.getHostName();
                }
                if (inetAddress.getHostName() != null) {
                    string = inetAddress.getHostName();
                    continue block2;
                }
                string = inetAddress.getHostAddress();
                continue block2;
            }
        }
        stringArray[0] = string2;
        stringArray[1] = string;
        return stringArray;
    }

    @GetMapping(value={"/versionInfo"})
    public ModelAndView versionInfo(ModelAndView modelAndView, HttpServletRequest httpServletRequest, @PathVariable(value="agentId") String string3) {
        LoadConfigFile.setAgentId((String)string3);
        String string4 = BuildVersion.getBuildVersion();
        StringBuilder stringBuilder = new StringBuilder();
        Map map = this.agentService.getFrameworkVersionMap(false);
        map.forEach((string, string2) -> {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" | ");
            }
            if (string2.startsWith("LATEST$")) {
                string2 = string2.substring("LATEST$".length()) + " (Latest)";
            }
            stringBuilder.append((String)string).append(" = ").append((String)string2);
        });
        modelAndView.setViewName("version-info");
        modelAndView.addObject("agentVersion", (Object)string4);
        modelAndView.addObject("frameworkVersions", (Object)stringBuilder.toString());
        modelAndView.addObject("localRequest", (Object)RestUtil.isLocalRequest((HttpServletRequest)httpServletRequest));
        modelAndView.addObject("isTestRunning", (Object)TestRunExecutionData.isAnyTestrunRunning());
        modelAndView.addObject("runningTests", (Object)TestRunExecutionData.getRunningTests());
        modelAndView.addObject("agentId", (Object)string3);
        return modelAndView;
    }

    @GetMapping(value={"/admin/startPreventLock"})
    public String startPreventLock(ModelAndView modelAndView, HttpServletRequest httpServletRequest) {
        SupportProcesses.startPreventLockProcess();
        return "Started";
    }

    @GetMapping(value={"/admin/startRdcDisconnect"})
    public String startRdcDisconnect(ModelAndView modelAndView, HttpServletRequest httpServletRequest) {
        SupportProcesses.startRdcDisconnectProcess();
        return "Started";
    }

    @PostMapping(value={"/saveAgent"})
    public ModelAndView saveAgentDetail(ModelAndView modelAndView, Agent agent) {
        return this.agentRegistrationService.registerAgent(agent, modelAndView);
    }

    @GetMapping(value={"/admin/reload"})
    public String reloadAgent(HttpServletRequest httpServletRequest) {
        if (!RestUtil.isLocalRequest((HttpServletRequest)httpServletRequest)) {
            return "unauthorized";
        }
        return AgentApplication.reload();
    }

    @GetMapping(value={"/admin/restart"})
    public String restartAgent(HttpServletRequest httpServletRequest, @PathVariable(value="agentId") int n2) {
        if (!RestUtil.isLocalRequest((HttpServletRequest)httpServletRequest)) {
            return "unauthorized";
        }
        return AgentApplication.shutdown((int)100);
    }

    @GetMapping(value={"/admin/shutdown"})
    public String shutdownAgent(HttpServletRequest httpServletRequest, @PathVariable(value="agentId") int n2) {
        if (!RestUtil.isLocalRequest((HttpServletRequest)httpServletRequest)) {
            return "unauthorized";
        }
        return AgentApplication.shutdown((int)0);
    }

    @GetMapping(value={"/admin/update"})
    public String updateAgent(HttpServletRequest httpServletRequest) {
        if (!RestUtil.isLocalRequest((HttpServletRequest)httpServletRequest)) {
            return "unauthorized";
        }
        return AgentApplication.shutdown((int)200);
    }

    @Scheduled(cron="0 0 2 * * ?")
    public void checkAndUpdateAgentBinary() {
        this.agentService.checkAllAgentUpdate();
    }

    @GetMapping(value={"/configureBrowser/{browser}"})
    public ModelAndView configureBrowser(ModelAndView modelAndView, @PathVariable(value="browser") String string) {
        try {
            logger.info("configureBrowser request received: {}", (Object)string);
            WindowsBrowserUtil.openBrowserProfile((Browser)Browser.getBrowser((String)string), null);
        }
        catch (Exception exception) {
            logger.error("Error configuring browser", (Throwable)exception);
        }
        modelAndView.setViewName("redirect");
        return modelAndView;
    }

    @GetMapping(value={"/configureBrowser/delete/{browser}"})
    public ModelAndView deleteBrowserProfile(ModelAndView modelAndView, @PathVariable(value="browser") String string) {
        try {
            logger.info("configureBrowser request received: {}", (Object)string);
            WindowsBrowserUtil.deleteBrowserProfile((Browser)Browser.getBrowser((String)string));
        }
        catch (Exception exception) {
            logger.error("Error configuring browser", (Throwable)exception);
        }
        modelAndView.setViewName("redirect");
        return modelAndView;
    }

    @GetMapping(value={"framework/{framework}/properties"}, produces={"application/json"})
    public ResponseEntity<Map<Object, Object>> getFrameworkProperties(@PathVariable(value="framework") String string) {
        Map map = this.agentService.getFrameworkProperties(string);
        return new ResponseEntity((Object)map, HttpStatus.OK);
    }

    @GetMapping(value={"/launch"})
    public ModelAndView launch(ModelAndView modelAndView, @PathVariable(value="agentId") String string) {
        modelAndView.addObject("agentId", (Object)string);
        modelAndView.setViewName("index");
        return modelAndView;
    }
}

