/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="file.browser")
public class FileBrowserConfig {
    private boolean allowUpwardNavigation = true;
    private boolean restrictedMode = false;
    private List<String> allowedPaths = new ArrayList();
    private long maxPreviewFileSizeMB = -1L;

    @PostConstruct
    public void init() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.allowedPaths) {
            try {
                arrayList.add(new File(string).getCanonicalPath());
            }
            catch (Exception exception) {
                System.err.println("Warning: Invalid allowed path: " + string);
            }
        }
        this.allowedPaths = arrayList;
    }

    public boolean isAllowUpwardNavigation() {
        return this.allowUpwardNavigation;
    }

    public void setAllowUpwardNavigation(boolean bl) {
        this.allowUpwardNavigation = bl;
    }

    public boolean isRestrictedMode() {
        return this.restrictedMode;
    }

    public void setRestrictedMode(boolean bl) {
        this.restrictedMode = bl;
    }

    public List<String> getAllowedPaths() {
        if (this.allowedPaths == null) {
            this.allowedPaths = new ArrayList();
        }
        return this.allowedPaths;
    }

    public void setAllowedPaths(List<String> list) {
        this.allowedPaths = list;
    }

    public long getMaxPreviewFileSizeMB() {
        return this.maxPreviewFileSizeMB;
    }

    public void setMaxPreviewFileSizeMB(long l2) {
        this.maxPreviewFileSizeMB = l2;
    }
}

