/*
 * Decompiled with CFR 0.152.
 */
package com.kumaran.tac.agent;

import com.kumaran.tac.agent.PostConfiguration;
import com.kumaran.tac.agent.controller.AgentController;
import com.kumaran.tac.agent.util.AgentAdminExecutor;
import com.kumaran.tac.agent.util.AgentExecutor;
import com.kumaran.tac.agent.util.AsyncUpdaterThread;
import com.kumaran.tac.agent.util.FrameworkQueueDetails;
import com.kumaran.tac.agent.util.LoadConfigFile;
import com.kumaran.tac.agent.util.MasterAgentExecutor;
import com.kumaran.tac.agent.util.RestUtil;
import com.kumaran.tac.common.dto.Attribute;
import com.kumaran.tac.common.dto.FieldDetail;
import com.kumaran.tac.common.enums.FrameworkPhase;
import com.kumaran.tac.common.servlet.FileServlet;
import com.kumaran.tac.common.util.CommonUtility;
import com.kumaran.tac.framework.selenium.common.frameworkLayer.SeleniumLocator;
import com.ulisesbocchio.jasyptspringboot.annotation.EnableEncryptableProperties;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.servlet.Servlet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.io.IoBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableScheduling
@EnableAsync
@EnableEncryptableProperties
@SpringBootApplication(scanBasePackages={"com.kumaran.tac.agent", "com.kumaran.tac.common", "com.kumaran.aspect", "com.kumaran.tac.spyExecutor", "com.kumaran.tac.framework"})
@Import(value={PostConfiguration.class})
public class AgentApplication {
    private static final Logger logger;
    private static ConfigurableApplicationContext context;
    private static List<String> appArgs;
    private static boolean startedViaBootstrapper;
    private static boolean isDevMode;
    private static boolean isDebugMode;
    private static boolean restartAgentForUpdate;
    private static boolean checkVersionUpgrade;
    private static String providedConfigFile;
    @Autowired
    MasterAgentExecutor masterAgentExecutor;
    @Autowired
    RestUtil restUtil;
    public static final int EXITCODE_NORMAL = 0;
    public static final int EXITCODE_RESTART = 100;
    public static final int EXITCODE_UPDATE = 200;

    static void updateSpringConfigLocation(String string) {
        String string2 = "classpath:tac-agent-defaults.properties,optional:file:./agent.properties";
        String string3 = System.getProperty("spring.config.location");
        if (string3 != null && !string3.startsWith(string2)) {
            string2 = string2 + string3;
        }
        if (string != null && !string.trim().isEmpty()) {
            string2 = string2 + ",optional:file:" + string;
        }
        System.out.println("Setting Spring Config Location to (in specific order): " + string2);
        System.out.println("Current directory: " + System.getProperty("user.dir"));
        System.setProperty("spring.config.location", string2);
    }

    public static void main(String[] springApplicationBuilder) {
        appArgs = new ArrayList();
        for (String string : springApplicationBuilder) {
            if (string.startsWith("--spring.config.location") || string.startsWith("--config")) {
                String string2 = string.substring(string.indexOf("=") + 1);
                if ("agent.properties".equals(string2)) continue;
                providedConfigFile = string2;
                AgentApplication.updateSpringConfigLocation((String)string2);
                continue;
            }
            appArgs.add(string);
        }
        springApplicationBuilder = appArgs.toArray(new String[0]);
        startedViaBootstrapper = appArgs.contains("--started-via-bootstraper");
        isDevMode = appArgs.contains("--dev");
        isDebugMode = appArgs.contains("--debug");
        if (isDevMode) {
            System.out.println("Agent started in Dev mode.");
        } else if (startedViaBootstrapper) {
            System.out.println("Agent started via bootstrapper.");
        } else {
            System.err.println("Agent is not started via bootstrapper.");
            System.err.println("Use command \"java -jar bootstrap-agent.jar\" to start the Agent.");
            System.err.println("You can adjust the startup settings in the 'agent.properties' file.");
            System.exit(100);
        }
        SpringApplicationBuilder springApplicationBuilder2 = new SpringApplicationBuilder(new Class[]{AgentApplication.class});
        springApplicationBuilder2.headless(false);
        context = springApplicationBuilder2.run((String[])springApplicationBuilder);
        System.setProperty("java.awt.headless", "false");
    }

    public static boolean isDevMode() {
        return isDevMode;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static String getProvidedConfigFile() {
        if (providedConfigFile == null) {
            return null;
        }
        File file = new File(providedConfigFile);
        if (file.isAbsolute() && file.exists()) {
            return providedConfigFile;
        }
        if (file.exists() && file.getParentFile() != null && file.getParentFile().equals(new File(AgentController.home))) {
            return file.getAbsolutePath();
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        File file2 = new File(AgentController.home, providedConfigFile);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        return providedConfigFile;
    }

    @PreDestroy
    public void onExit() {
        this.masterAgentExecutor.stop();
    }

    public static String reload() {
        ApplicationArguments applicationArguments = (ApplicationArguments)context.getBean(ApplicationArguments.class);
        String string = LoadConfigFile.getAgentId();
        Thread thread = new Thread(() -> {
            LoadConfigFile.setAgentId((String)string);
            AgentApplication.setRestartAgentForUpdate((boolean)false);
            context.close();
            context = SpringApplication.run(AgentApplication.class, (String[])applicationArguments.getSourceArgs());
            MasterAgentExecutor.setServerUrlExists((boolean)false);
        });
        thread.setDaemon(false);
        thread.start();
        return "success";
    }

    public static String shutdown(int n2) {
        ApplicationArguments applicationArguments = (ApplicationArguments)context.getBean(ApplicationArguments.class);
        String string = LoadConfigFile.getAgentId();
        Thread thread = new Thread(() -> {
            LoadConfigFile.setAgentId((String)string);
            context.close();
            MasterAgentExecutor.setServerUrlExists((boolean)false);
            System.exit(n2);
        });
        thread.setDaemon(false);
        thread.start();
        if (startedViaBootstrapper) {
            return "success";
        }
        return "warning";
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public CommandLineRunner schedulingRunner(@Qualifier(value="taskExecutor") TaskExecutor taskExecutor) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public TaskExecutor taskExecutor() {
        return new SimpleAsyncTaskExecutor();
    }

    @Bean(name={"seleniumLocatorAgent"})
    @Scope(value="prototype")
    public SeleniumLocator getSeleniumLocator(Attribute attribute, FrameworkPhase frameworkPhase) {
        return new SeleniumLocator(attribute, frameworkPhase);
    }

    @Bean(name={"singleGroupLoctorAgent"})
    @Scope(value="prototype")
    public SeleniumLocator getSingleGroupLocator(Attribute attribute, List<FieldDetail> list, FrameworkPhase frameworkPhase) {
        return new SeleniumLocator(attribute, list, frameworkPhase);
    }

    public static boolean getRestartAgentForUpdate() {
        return restartAgentForUpdate;
    }

    public static void setRestartAgentForUpdate(boolean bl) {
        restartAgentForUpdate = bl;
    }

    public static boolean checkVersionUpgrade() {
        return checkVersionUpgrade;
    }

    public static void checkVersionUpgrade(boolean bl) {
        checkVersionUpgrade = bl;
    }

    @Bean
    public ServletRegistrationBean logsServletBean() {
        File file = CommonUtility.LOGS_FOLDER;
        if (!file.exists()) {
            file.mkdir();
        }
        System.err.println(">>>> Registering Servlet: FileServlet as logsServletBean as logsServlet");
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new FileServlet(), new String[]{"/logs", "/logs/*"});
        servletRegistrationBean.setName("logsServlet");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("basePath", file.getAbsolutePath());
        hashMap.put("showFolders", "true");
        servletRegistrationBean.setInitParameters(hashMap);
        servletRegistrationBean.setLoadOnStartup(1);
        return servletRegistrationBean;
    }

    @Bean(name={"agentExecutor"})
    @Scope(value="prototype")
    public AgentExecutor initiateAgentExecutor(String string) {
        return new AgentExecutor(Objects.requireNonNull(string));
    }

    @Bean(name={"agentAdminExecutor"})
    @Scope(value="prototype")
    public AgentAdminExecutor initiateAgentAdminExecutor(AgentExecutor agentExecutor) {
        return new AgentAdminExecutor(agentExecutor);
    }

    @Bean(name={"frameworkQueueDetails"})
    @Scope(value="prototype")
    public FrameworkQueueDetails initiateFrameworkQueue(AgentExecutor agentExecutor) {
        return new FrameworkQueueDetails(agentExecutor);
    }

    @Bean(name={"asyncUpdaterThread"})
    @Scope(value="prototype")
    public AsyncUpdaterThread initiateAsyncUpdaterThread(AgentExecutor agentExecutor) {
        return new AsyncUpdaterThread(agentExecutor);
    }

    static {
        Object object;
        logger = LoggerFactory.getLogger(AgentApplication.class);
        appArgs = null;
        startedViaBootstrapper = false;
        isDevMode = false;
        isDebugMode = false;
        restartAgentForUpdate = false;
        checkVersionUpgrade = false;
        providedConfigFile = null;
        System.setProperty("log4j2.contextSelector", "org.apache.logging.log4j.core.async.BasicAsyncLoggerContextSelector");
        String string = System.getProperty("user.dir");
        File file = new File(string, "developer-machine.txt");
        boolean bl = false;
        if (file.exists()) {
            bl = true;
        } else {
            file = new File(string, "../developer-machine.txt");
            if (file.exists()) {
                bl = true;
            }
        }
        System.setProperty("IS_DEV_MACHINE", bl ? "TRUE" : "FALSE");
        String string2 = System.getProperty("instance-id");
        if (string2 == null) {
            object = new SimpleDateFormat("DDDHHmmssSSS");
            string2 = ((DateFormat)object).format(new Date());
        }
        System.setProperty("AGENT_INSTANCE_ID", string2);
        System.out.println("Using Agent 'instance-id' as " + string2);
        object = System.getProperty("agent-id");
        if (object != null) {
            System.setProperty("CURRENT_AGENT_ID", (String)object);
        }
        PrintStream printStream = IoBuilder.forLogger((String)"System.out").setLevel(Level.INFO).buildPrintStream();
        PrintStream printStream2 = IoBuilder.forLogger((String)"System.err").setLevel(Level.ERROR).buildPrintStream();
        System.setOut(printStream);
        System.setErr(printStream2);
        AgentApplication.updateSpringConfigLocation(null);
    }
}

